/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.openzen.packetstreams.NetworkLogger;
import org.openzen.packetstreams.PacketHints;
import org.openzen.packetstreams.PacketStream;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.ServiceConnector;
import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.ServiceStream;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.frames.AckFrame;
import org.openzen.packetstreams.qpsp.frames.CloseFrame;
import org.openzen.packetstreams.qpsp.frames.DataFrame;
import org.openzen.packetstreams.qpsp.frames.FinishPacketFrame;
import org.openzen.packetstreams.qpsp.frames.FragEndFrame;
import org.openzen.packetstreams.qpsp.frames.FragPartFrame;
import org.openzen.packetstreams.qpsp.frames.FragStartFrame;
import org.openzen.packetstreams.qpsp.frames.FrameQueue;
import org.openzen.packetstreams.qpsp.frames.OpenFrame;
import org.openzen.packetstreams.qpsp.frames.ServiceInfoFrame;
import org.openzen.packetstreams.qpsp.frames.StartFrame;

public class QPSPStream
implements PacketStream {
    public final QPSPSession session;
    public final NetworkLogger logger;
    public final long localId;
    public long remoteId;
    private long outgoingSeq = 0L;
    private long outgoingLossySeq = 0L;
    protected final Timer timer = new Timer();
    private Service service;
    private final ServiceConnector connector;
    private ServiceStream serviceStream;
    protected final FrameQueue incomingQueue = new FrameQueue(this);
    private long lastConfirmedSeq = -1L;
    private long currentSeq = 0L;
    private int currentDataSeq = 0;
    private int priority = 0;
    private BytesDataOutput incomingFragment = null;
    private final Queue<RawPacket> controlPacketBuffer = new LinkedList<RawPacket>();
    private byte[] outgoingPacket = null;
    private int outgoingFragmentOffset = 0;
    private boolean sendServiceMeta = false;
    private boolean closed = false;

    public QPSPStream(final QPSPSession session, long localId, long remoteId, ServiceConnector connector) {
        this.session = session;
        this.logger = session.logger;
        this.localId = localId;
        this.remoteId = remoteId;
        this.connector = connector;
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                session.commandQueue.offer(() -> {
                    if (!QPSPStream.this.controlPacketBuffer.isEmpty() || QPSPStream.this.outgoingPacket != null) {
                        session.resume(QPSPStream.this);
                    }
                });
            }
        }, 50L, 50L);
    }

    public void open(String path, boolean quick) {
        BytesDataOutput frame = new BytesDataOutput();
        frame.writeUByte(quick ? 2 : 1);
        frame.writeString(path);
        this.enqueueControlFrame(frame.toByteArray());
    }

    public void connect(ServiceMeta meta) {
        if (this.connector == null) {
            throw new IllegalStateException("This is not a client stream");
        }
        byte[] init = this.connector.connect(meta);
        this.priority = meta.defaultPriority;
        BytesDataOutput frame = new BytesDataOutput();
        frame.writeUByte(4);
        frame.writeUInt(meta.checksum());
        frame.writeVarInt(this.priority);
        frame.writeByteArray(init);
        this.enqueueControlFrame(frame.toByteArray());
        this.serviceStream = this.connector.onConnected(this);
        this.serviceStream.onConnected();
        this.session.resume(this);
    }

    protected void enqueueControlFrame(byte[] frame) {
        this.controlPacketBuffer.add(new RawPacket(frame, false, false));
    }

    protected void enqueueControlFrame(RawPacket frame) {
        this.controlPacketBuffer.add(frame);
    }

    public Server getServer() {
        return this.session.server;
    }

    public Service getService() {
        return this.service;
    }

    public int getPriority() {
        return this.priority;
    }

    public long decodeCompactedSEQ(BytesDataInput input) {
        return input.readVarULong();
    }

    public void encodeCompactedSEQ(BytesDataOutput output, long value) {
        output.writeVarULong(value);
    }

    private void enqueueAck(long seq) {
        BytesDataOutput ack = new BytesDataOutput();
        ack.writeVarUInt(6);
        this.encodeCompactedSEQ(ack, seq);
        this.enqueueControlFrame(new RawPacket(ack.toByteArray(), true, false));
    }

    public void onReceived(long seq, boolean lossy, byte[] data) {
        if (!lossy) {
            this.enqueueAck(seq);
        }
        if (!lossy && seq < this.currentSeq) {
            this.logger.log(4, this.localId, "Dropping duplicate packet " + seq);
            if (this.closed) {
                this.session.resume(this);
            }
            return;
        }
        if (lossy) {
            this.logger.log(4, this.localId, "Processing incoming lossy packet " + seq);
        } else {
            this.logger.log(4, this.localId, "Processing incoming packet " + seq);
        }
        BytesDataInput input = new BytesDataInput(data);
        int dataseq = 0;
        block12: while (input.hasMore()) {
            int type = input.readUByte();
            switch (type) {
                case 1: {
                    String path = input.readString();
                    this.logger.log(4, this.localId, "<- OPEN " + path);
                    this.incomingQueue.offer(new OpenFrame(seq, path, true));
                    continue block12;
                }
                case 2: {
                    String path = input.readString();
                    this.logger.log(4, this.localId, "<- QUICKOPEN " + path);
                    this.incomingQueue.offer(new OpenFrame(seq, path, false));
                    continue block12;
                }
                case 3: {
                    UUID uuid = input.readUUID();
                    int flags = input.readUByte();
                    this.priority = input.readVarInt();
                    byte[] serviceInfo = input.readByteArray();
                    this.logger.log(4, this.localId, "<- SERVICEINFO");
                    this.incomingQueue.offer(new ServiceInfoFrame(new ServiceMeta(uuid, flags, this.priority, serviceInfo)));
                    continue block12;
                }
                case 4: {
                    this.logger.log(4, this.localId, "<- START");
                    int checksum = input.readUInt();
                    int priority = input.readVarInt();
                    byte[] initData = input.readByteArray();
                    this.incomingQueue.offer(new StartFrame(checksum, priority, initData));
                    continue block12;
                }
                case 5: {
                    this.logger.log(4, this.localId, "<- DATA");
                    byte[] packetData = input.readByteArray();
                    this.incomingQueue.offer(new DataFrame(seq, dataseq++, packetData));
                    continue block12;
                }
                case 6: {
                    long ackseq = this.decodeCompactedSEQ(input);
                    this.logger.log(4, this.localId, "<- ACK " + ackseq);
                    this.session.onAcknowledged(this.localId, ackseq);
                    this.incomingQueue.offer(new AckFrame(ackseq));
                    continue block12;
                }
                case 7: {
                    int reason = input.readVarUInt();
                    this.logger.log(4, this.localId, "<- CLOSE " + reason);
                    byte[] closeData = input.readByteArray();
                    this.incomingQueue.offer(new CloseFrame(seq, dataseq++, reason, closeData));
                    continue block12;
                }
                case 8: {
                    this.logger.log(4, this.localId, "<- FRAGSTART");
                    byte[] fragment = input.readByteArray();
                    this.incomingQueue.offer(new FragStartFrame(seq, dataseq++, fragment));
                    continue block12;
                }
                case 9: {
                    this.logger.log(4, this.localId, "<- FRAGPART");
                    byte[] fragment = input.readByteArray();
                    this.incomingQueue.offer(new FragPartFrame(seq, dataseq++, fragment));
                    continue block12;
                }
                case 10: {
                    this.logger.log(4, this.localId, "<- FRAGEND");
                    byte[] fragment = input.readByteArray();
                    this.incomingQueue.offer(new FragEndFrame(seq, dataseq++, fragment));
                    continue block12;
                }
            }
            this.handleUnknown(type, input);
        }
        if (!lossy) {
            this.incomingQueue.offer(new FinishPacketFrame(seq));
        }
    }

    @Override
    public void resume() {
        this.session.commandQueue.offer(() -> this.session.resume(this));
    }

    @Override
    public void close(int reason, byte[] info) {
        this.session.commandQueue.offer(() -> {
            BytesDataOutput close = new BytesDataOutput();
            close.writeUByte(7);
            close.writeVarUInt(reason);
            close.writeByteArray(info);
            this.enqueueControlFrame(close.toByteArray());
            this.session.resume(this);
        });
    }

    @Override
    public CryptoProvider getCrypto() {
        return this.session.getCrypto();
    }

    @Override
    public int getEstimatedRTTInMillis() {
        return this.session.getEstimatedRTTInMillis();
    }

    public void handleUnknown(int type, BytesDataInput input) {
        this.close(3, new byte[0]);
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void transmitServiceMeta() {
        this.sendServiceMeta = true;
        this.session.resume(this);
    }

    public void start(int priority, byte[] initData) {
        this.serviceStream = this.service.open(this, initData);
        this.serviceStream.onConnected();
        this.priority = priority;
    }

    public boolean isStarted() {
        return this.serviceStream != null;
    }

    public void deliverServiceInfo(ServiceMeta meta) {
        this.connect(meta);
    }

    public void deliver(long seq, int dataseq, byte[] packet) {
        if (seq != this.currentSeq || dataseq != this.currentDataSeq) {
            this.session.logger.log(4, this.localId, "Preventing duplicate delivery of " + seq + "::" + dataseq);
            return;
        }
        this.serviceStream.onReceived(packet);
        ++this.currentDataSeq;
    }

    public void deliverClose(long seq, int dataseq, int reason, byte[] info) {
        if (seq != this.currentSeq && dataseq != this.currentDataSeq) {
            this.session.logger.log(4, this.localId, "Preventing duplicate delivery of " + seq + "::" + dataseq);
            return;
        }
        if (reason != 0) {
            this.close(0, new byte[0]);
        }
        this.timer.cancel();
        this.service = null;
        ++this.currentDataSeq;
        this.closed = true;
        this.session.resume(this);
        this.session.onClosed(this.localId);
        if (this.serviceStream != null) {
            this.serviceStream.onConnectionClosed(reason, info);
        }
    }

    public boolean finishPacket(long seq) {
        if (seq < this.currentSeq) {
            return true;
        }
        if (seq != this.currentSeq) {
            return false;
        }
        this.logger.log(4, this.localId, "Finished " + seq);
        ++this.currentSeq;
        this.currentDataSeq = 0;
        return true;
    }

    public void beginFragmented(byte[] data) {
        if (this.incomingFragment != null) {
            this.close(3, new byte[0]);
            return;
        }
        this.incomingFragment = new BytesDataOutput();
        this.incomingFragment.writeRawBytes(data);
    }

    public void appendFragmented(byte[] data) {
        if (this.incomingFragment == null) {
            this.close(3, new byte[0]);
            return;
        }
        this.incomingFragment.writeRawBytes(data);
    }

    public void finishFragmented(long seq, int dataseq, byte[] data) {
        if (this.incomingFragment == null) {
            this.close(3, new byte[0]);
            return;
        }
        BytesDataInput input = new BytesDataInput(data);
        int fragmentType = input.readUByte();
        switch (fragmentType) {
            case 3: {
                UUID uuid = input.readUUID();
                int flags = input.readUByte();
                int defaultPriority = input.readVarInt();
                byte[] serviceInfo = input.readByteArray();
                this.deliverServiceInfo(new ServiceMeta(uuid, flags, defaultPriority, serviceInfo));
                break;
            }
            case 4: {
                int checksum = input.readVarUInt();
                int priority = input.readVarUInt();
                byte[] initData = input.readByteArray();
                this.incomingQueue.offer(new StartFrame(checksum, priority, initData));
                break;
            }
            case 5: {
                byte[] packetData = input.readByteArray();
                this.deliver(seq, dataseq, packetData);
                break;
            }
            case 7: {
                int reason = input.readVarUInt();
                byte[] closeData = input.readByteArray();
                this.deliverClose(seq, dataseq, reason, data);
                break;
            }
            default: {
                this.close(3, new byte[0]);
            }
        }
        this.incomingFragment = null;
    }

    public boolean ack(long seq) {
        if (seq >= this.lastConfirmedSeq) {
            return true;
        }
        if (seq == this.lastConfirmedSeq - 1L) {
            ++this.lastConfirmedSeq;
            return true;
        }
        return false;
    }

    public boolean hasReached(long seq, int dataseq) {
        return seq == this.currentSeq && dataseq == this.currentDataSeq || seq < this.currentSeq;
    }

    public QPSPPacket next() {
        long l;
        if (this.remoteId == -1L) {
            this.logger.log(4, this.localId, "Remote id not yet known, delaying transmission");
            return null;
        }
        RawPacket nextRaw = this.nextRaw();
        if (nextRaw == null) {
            return null;
        }
        if (nextRaw.lossy) {
            long l2 = this.outgoingLossySeq;
            l = l2;
            this.outgoingLossySeq = l2 + 1L;
        } else {
            long l3 = this.outgoingSeq;
            l = l3;
            this.outgoingSeq = l3 + 1L;
        }
        long seq = l;
        long remoteStreamID = nextRaw.lossy ? this.remoteId | 2L : this.remoteId;
        byte[] encrypted = this.session.encrypt(nextRaw.data, remoteStreamID, seq);
        BytesDataOutput packet = new BytesDataOutput();
        packet.writeVarULong(remoteStreamID);
        this.encodeCompactedSEQ(packet, seq);
        packet.writeRawBytes(encrypted);
        return new QPSPPacket(this.priority, nextRaw.lossy ? this.localId | 2L : this.localId, seq, packet.toByteArray(), nextRaw.keepalive);
    }

    private RawPacket nextRaw() {
        RawPacket next;
        boolean lossy = true;
        boolean hasData = false;
        boolean keepalive = false;
        int available = this.session.maxUDPPacketSize;
        BytesDataOutput output = new BytesDataOutput();
        while (!this.controlPacketBuffer.isEmpty() && (next = this.controlPacketBuffer.peek()) != null) {
            lossy &= next.lossy;
            keepalive |= next.keepalive;
            if (output.length() + next.data.length < this.session.maxUDPPacketSize) {
                this.controlPacketBuffer.poll();
                available -= next.data.length;
                output.writeRawBytes(next.data);
                hasData = true;
                continue;
            }
            if (!hasData) {
                throw new IllegalStateException("Control packet doesn't fit in the output; length: " + next.data.length);
            }
            return new RawPacket(output.toByteArray(), lossy, keepalive);
        }
        if (this.outgoingPacket == null && this.sendServiceMeta) {
            lossy = false;
            BytesDataOutput meta = new BytesDataOutput();
            ServiceMeta metadata = this.service.getMeta();
            meta.writeUByte(3);
            meta.writeUUID(metadata.uuid);
            meta.writeUByte(metadata.flags);
            meta.writeVarInt(metadata.defaultPriority);
            meta.writeByteArray(metadata.serviceInfo);
            this.outgoingPacket = meta.toByteArray();
            this.outgoingFragmentOffset = 0;
            this.sendServiceMeta = false;
        }
        while (available > 32) {
            if (this.outgoingPacket == null && this.serviceStream != null) {
                this.outgoingPacket = this.nextData(Math.max(512, available - 5));
                this.outgoingFragmentOffset = 0;
            }
            if (this.outgoingPacket == null) break;
            lossy = false;
            hasData = true;
            if (this.outgoingFragmentOffset != 0 || this.outgoingPacket.length + 5 > available) {
                available -= this.nextFragment(output, available);
                continue;
            }
            output.writeRawBytes(this.outgoingPacket);
            available -= this.outgoingPacket.length;
            this.outgoingPacket = null;
        }
        if (!hasData) {
            return null;
        }
        return new RawPacket(output.toByteArray(), lossy, keepalive);
    }

    private byte[] nextData(int availableSpaceInPacket) {
        int recommendedLength = availableSpaceInPacket - this.getSizeLength(availableSpaceInPacket) - 1;
        byte[] packet = this.serviceStream.next(new PacketHints(recommendedLength));
        if (packet == null) {
            return null;
        }
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(5);
        output.writeByteArray(packet);
        return output.toByteArray();
    }

    private int getSizeLength(int size) {
        if (size < 128) {
            return 1;
        }
        if (size < 16384) {
            return 2;
        }
        if (size < 0x200000) {
            return 3;
        }
        if (size < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private int nextFragment(BytesDataOutput output, int size) {
        if (this.outgoingFragmentOffset == 0) {
            output.writeUByte(8);
            output.writeBytes(this.outgoingPacket, 0, size);
            this.outgoingFragmentOffset += size;
            return size + 1;
        }
        if (this.outgoingPacket.length - this.outgoingFragmentOffset > size) {
            output.writeUByte(9);
            output.writeBytes(this.outgoingPacket, this.outgoingFragmentOffset, size);
            this.outgoingFragmentOffset += size;
            return size + 1;
        }
        output.writeUByte(10);
        output.writeBytes(this.outgoingPacket, this.outgoingFragmentOffset, this.outgoingPacket.length - this.outgoingFragmentOffset);
        int written = this.outgoingPacket.length - this.outgoingFragmentOffset + 1;
        this.outgoingPacket = null;
        return written;
    }

    protected class RawPacket {
        public final byte[] data;
        public final boolean lossy;
        public final boolean keepalive;

        public RawPacket(byte[] data, boolean lossy, boolean keepalive) {
            this.data = data;
            this.lossy = lossy;
            this.keepalive = keepalive;
        }
    }
}

