/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import java.util.Arrays;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;

/**
 * Requires that the signing root be exactly the one as specified here. If you
 * know the signing key that will be used, use this validator.
 */
public class PinnedRootValidator implements SigningRootValidator {
	private final byte[] rootVerifyKey;
	
	public PinnedRootValidator(byte[] rootVerifyKey) {
		this.rootVerifyKey = rootVerifyKey;
	}

	@Override
	public boolean isValid(CryptoVerifyKey rootKey) {
		return Arrays.equals(rootVerifyKey, rootKey.encode());
	}
}
