package org.openzen.packetstreams.qpsp;

/**
 * Represents a single packet being transmitted.
 */
public class QPSPPacket implements Comparable<QPSPPacket> {
	public final int priority;
	public final long localStreamID;
	public final long seq;
	public final byte[] data;
	public final long timestamp;
	
	public QPSPPacket(int priority, long localStreamID, long seq, byte[] data) {
		this.priority = priority;
		this.localStreamID = localStreamID;
		this.seq = seq;
		this.data = data;
		timestamp = System.currentTimeMillis();
	}
	
	public boolean isLossy() {
		return (localStreamID & 2) == 2;
	}

	@Override
	public int compareTo(QPSPPacket o) {
		if (priority != o.priority)
			return o.priority - priority;
		if (localStreamID != o.localStreamID)
			return (int)(localStreamID - o.localStreamID); // packets in the same stream are not that far apart (spec)
		
		return (int)(seq - o.seq); // no more than 2^31 packets in flight (spec)
	}
}
