/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.scheduler;

import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;

/**
 * Implements a congestion controller for the StandardPacketScheduler. Different
 * implementations may be created to experiment with alternative algorithms.
 */
public interface CongestionController {
	void setPacketScheduler(StandardPacketScheduler scheduler);
	
	boolean isCongested();
	
	void onSent(QPSPPacket packet);
	
	void onAckLossless(QPSPPacket packet);
	
	void onAckDuplicate(long streamID, long seq);
	
	void onPacketLost(QPSPPacket packet);
	
	String getStateInfo();
}
