/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;

/**
 * Provides an UDP socket implementation. Switching out different
 * implementations may be used for testing purposes.
 */
public interface UDPSocket {
	DatagramPacket receive() throws IOException;
	
	void send(DatagramPacket packet) throws IOException;
	
	void close();
	
	int getTotalPacketsTransmitted();
	
	long getTotalDataTransmitted();
	
	int getTotalPacketsReceived();
	
	long getTotalDataReceived();
}
