/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Represents a single service. Services contain meta information about the
 * service, the priority the streams should run at, and a method to open a
 * service stream with the actual service implementation.
 */
public interface Service {
	int FLAG_META_CACHEABLE = 1;
	int FLAG_CLIENT_SERVER_UNORDERED = 2;
	int FLAG_SERVER_CLIENT_UNORDERED = 4;
	
	/**
	 * Retrieves the service metadata. Should return the same data with every
	 * invocation.
	 * 
	 * @return service metadata
	 */
	ServiceMeta getMeta();
	
	/**
	 * Retrieves the service's priority. Higher values indicate
	 * higher priority. Default value is 0 for regular streams and 100 for
	 * the control stream.
	 * 
	 * @return service priority
	 */
	default int getDefaultPriority() {
		return 0;
	}
	
	/**
	 * Opens a service stream. This method will be invoked for every connecting
	 * client. The returned service stream should provide the actual service
	 * implementation.
	 * 
	 * @param stream packet stream for the service stream
	 * @param initializer initializer data
	 * @return service stream implementation
	 */
	ServiceStream open(PacketStream stream, byte[] initializer);
}
