/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp;

/**
 * The PacketScheduler transmits and retransmits packets. Different interface 
 * implementations can provide different algorithms.
 */
public interface PacketScheduler {
	/**
	 * Pauses the stream. Stops it from transmitting anything.
	 */
	void pause();
	
	/**
	 * Resumes the stream after pausing. Continues data transmission.
	 */
	void resume();
	
	/**
	 * Indicates that new data is available for transmission.
	 */
	void resumeStreams();
	
	/**
	 * Registers the acknowledgement of a packet. Indicates that the packet has
	 * been successfully received (and doesn't need to be retransmitted)
	 * 
	 * @param streamID stream ID
	 * @param seq SEQ number
	 */
	void onAcknowledged(long streamID, long seq);
	
	/**
	 * Notifies the closing of a stream. All data for that stream should be
	 * cleaned up.
	 * 
	 * @param streamID 
	 */
	void onStreamClosed(long streamID);
	
	void onSessionClosed();
	
	int getEstimatedRTTInMillis();
	
	long getLastSentPacketTimestamp();
}
