/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

public class QPSPPacket
implements Comparable<QPSPPacket> {
    public final int priority;
    public final long localStreamID;
    public final long seq;
    public final byte[] data;
    public final long timestamp;

    public QPSPPacket(int priority, long localStreamID, long seq, byte[] data) {
        this.priority = priority;
        this.localStreamID = localStreamID;
        this.seq = seq;
        this.data = data;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isLossy() {
        return (this.localStreamID & 2L) == 2L;
    }

    @Override
    public int compareTo(QPSPPacket o) {
        if (this.priority != o.priority) {
            return o.priority - this.priority;
        }
        if (this.localStreamID != o.localStreamID) {
            return (int)(this.localStreamID - o.localStreamID);
        }
        return (int)(this.seq - o.seq);
    }
}

