/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPStream;

public class CloseFrame implements Frame {
	private final long seq;
	private final int dataseq;
	private final int reason;
	private final byte[] info;
	
	public CloseFrame(long seq, int dataseq, int reason, byte[] info) {
		this.seq = seq;
		this.dataseq = dataseq;
		this.reason = reason;
		this.info = info;
	}

	@Override
	public boolean tryExecute(QPSPStream stream) {
		if (!stream.hasReached(seq, dataseq))
			return false;
		
		stream.deliverClose(seq, dataseq, reason, info);
		return true;
	}
}
