/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.qpsp.Constants;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class OpenFrame implements Frame {
	private final long seq;
	private final String path;
	private final boolean emitServiceInfo;
	
	public OpenFrame(long seq, String path, boolean emitServiceInfo) {
		this.seq = seq;
		this.path = path;
		this.emitServiceInfo = emitServiceInfo;
	}
	
	@Override
	public boolean tryExecute(QPSPStream stream) {
		Server server = stream.getServer();
		Service service = server.getService(path);
		if (service == null) {
			stream.close(Constants.CLOSE_SERVICE_NOT_FOUND, new byte[0]);
		} else {
			stream.setService(service);
		}
			
		if (emitServiceInfo)
			stream.transmitServiceMeta();
		
		return true;
	}
}
