/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.io;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.UUID;
import org.openzen.packetstreams.io.DataInput;

public class BytesDataInput
implements DataInput {
    private static final int P7 = 128;
    private static final int P14 = 16384;
    private static final int P21 = 0x200000;
    private static final int P28 = 0x10000000;
    private static final long P35 = 0x800000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P56 = 0x100000000000000L;
    private byte[] data;
    private int index;
    private int limit;

    public BytesDataInput(byte[] data) {
        this.data = data;
        this.index = 0;
        this.limit = data.length;
    }

    public BytesDataInput(byte[] data, int offset, int length) {
        this.data = data;
        this.index = offset;
        this.limit = offset + length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getCurrentOffset() {
        return this.index;
    }

    public int getAvailable() {
        return this.limit - this.index;
    }

    @Override
    public boolean readBoolean() {
        return this.readUByte() != 0;
    }

    @Override
    public byte readSByte() {
        return this.data[this.index++];
    }

    @Override
    public int readUByte() {
        return this.data[this.index++] & 0xFF;
    }

    @Override
    public short readShort() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        return (short)(b0 << 8 | b1);
    }

    @Override
    public int readUShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        int b2 = this.data[this.index++] & 0xFF;
        int b3 = this.data[this.index++] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    @Override
    public int readUInt() {
        return this.readInt();
    }

    @Override
    public long readLong() {
        long i0 = (long)this.readInt() & 0xFFFFFFFFL;
        long i1 = (long)this.readInt() & 0xFFFFFFFFL;
        return i0 << 32 | i1;
    }

    @Override
    public long readULong() {
        return this.readLong();
    }

    @Override
    public int readVarInt() {
        int value = this.readVarUInt();
        return (value & 1) == 0 ? value >>> 1 : -((value >>> 1) + 1);
    }

    @Override
    public int readVarUInt() {
        int value;
        if (((value = this.data[this.index++] & 0xFF) & 0x80) == 0) {
            return value;
        }
        if (((value = value & 0x7F | (this.data[this.index++] & 0xFF) << 7) & 0x4000) == 0) {
            return value;
        }
        if (((value = value & 0x3FFF | (this.data[this.index++] & 0xFF) << 14) & 0x200000) == 0) {
            return value;
        }
        if (((value = value & 0x1FFFFF | (this.data[this.index++] & 0xFF) << 21) & 0x10000000) == 0) {
            return value;
        }
        return value & 0xFFFFFFF | (this.data[this.index++] & 0xFF) << 28;
    }

    @Override
    public long readVarLong() {
        long value = this.readVarULong();
        return (value & 1L) == 0L ? value >>> 1 : -((value >>> 1) + 1L);
    }

    @Override
    public long readVarULong() {
        long value;
        if (((value = (long)(this.data[this.index++] & 0xFF)) & 0x80L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FL | (long)((this.data[this.index++] & 0xFF) << 7)) & 0x4000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFL | (long)((this.data[this.index++] & 0xFF) << 14)) & 0x200000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFL | (long)((this.data[this.index++] & 0xFF) << 21)) & 0x10000000L) == 0L) {
            return value;
        }
        if (((value = value & 0xFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 28) & 0x800000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 35) & 0x40000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 42) & 0x2000000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 49) & 0x100000000000000L) == 0L) {
            return value;
        }
        return value & 0xFFFFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 56;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readChar() {
        return this.readVarUInt();
    }

    @Override
    public String readString() {
        int size = this.readVarUInt();
        return new String(this.readRawBytes(size), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readBytes() {
        int size = this.readVarUInt();
        return this.readRawBytes(size);
    }

    @Override
    public byte[] readRawBytes(int size) {
        byte[] result = Arrays.copyOfRange(this.data, this.index, this.index + size);
        this.index += size;
        return result;
    }

    @Override
    public boolean[] readBoolArray() {
        int size = this.readVarUInt();
        boolean[] result = new boolean[size];
        for (int i = 0; i < (size + 7) / 8; ++i) {
            int bvalue = this.readUByte();
            int remainingBits = result.length - 8 * i;
            if (remainingBits > 0) {
                boolean bl = result[i * 8 + 0] = (bvalue & 1) > 0;
            }
            if (remainingBits > 1) {
                boolean bl = result[i * 8 + 1] = (bvalue & 2) > 0;
            }
            if (remainingBits > 2) {
                boolean bl = result[i * 8 + 2] = (bvalue & 4) > 0;
            }
            if (remainingBits > 3) {
                boolean bl = result[i * 8 + 3] = (bvalue & 8) > 0;
            }
            if (remainingBits > 4) {
                boolean bl = result[i * 8 + 4] = (bvalue & 0x10) > 0;
            }
            if (remainingBits > 5) {
                boolean bl = result[i * 8 + 5] = (bvalue & 0x20) > 0;
            }
            if (remainingBits > 6) {
                boolean bl = result[i * 8 + 6] = (bvalue & 0x40) > 0;
            }
            if (remainingBits <= 7) continue;
            result[i * 8 + 7] = (bvalue & 0x80) > 0;
        }
        return result;
    }

    @Override
    public byte[] readByteArray() {
        return this.readBytes();
    }

    @Override
    public byte[] readUByteArray() {
        return this.readBytes();
    }

    @Override
    public short[] readShortArray() {
        return this.readShortArray(this.readVarUInt());
    }

    @Override
    public short[] readShortArray(int length) {
        short[] result = new short[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    @Override
    public short[] readUShortArray() {
        return this.readShortArray();
    }

    @Override
    public short[] readUShortArray(int length) {
        return this.readShortArray(length);
    }

    @Override
    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readVarUInt());
    }

    @Override
    public int[] readVarIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarInt();
        }
        return result;
    }

    @Override
    public int[] readVarUIntArray() {
        return this.readVarUIntArray(this.readVarUInt());
    }

    @Override
    public int[] readVarUIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarUInt();
        }
        return result;
    }

    @Override
    public int[] readIntArray() {
        return this.readIntArray(this.readVarUInt());
    }

    @Override
    public int[] readIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    @Override
    public int[] readUIntArray() {
        int[] result = new int[this.readVarUInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readUInt();
        }
        return result;
    }

    @Override
    public long[] readVarLongArray() {
        return this.readVarLongArray(this.readVarUInt());
    }

    @Override
    public long[] readVarLongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarLong();
        }
        return result;
    }

    @Override
    public long[] readVarULongArray() {
        return this.readVarULongArray(this.readVarUInt());
    }

    @Override
    public long[] readVarULongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarULong();
        }
        return result;
    }

    @Override
    public long[] readLongArray() {
        return this.readLongArray(this.readVarUInt());
    }

    @Override
    public long[] readLongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readLong();
        }
        return result;
    }

    @Override
    public long[] readULongArray() {
        return this.readLongArray();
    }

    @Override
    public long[] readULongArray(int length) {
        return this.readLongArray(length);
    }

    @Override
    public float[] readFloatArray() {
        return this.readFloatArray(this.readVarUInt());
    }

    @Override
    public float[] readFloatArray(int length) {
        float[] result = new float[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    @Override
    public double[] readDoubleArray() {
        return this.readDoubleArray(this.readVarUInt());
    }

    @Override
    public double[] readDoubleArray(int length) {
        double[] result = new double[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    @Override
    public String[] readStringArray() {
        return this.readStringArray(this.readVarUInt());
    }

    @Override
    public String[] readStringArray(int length) {
        String[] result = new String[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readString();
        }
        return result;
    }

    @Override
    public LocalDate readDate() {
        int value = this.readVarInt();
        if (value == -32) {
            return null;
        }
        int year = value / 372 + 2000;
        int monthsAndDays = value % 372;
        if (value < 0) {
            --year;
            monthsAndDays += 372;
        }
        int month = monthsAndDays / 31;
        int day = monthsAndDays % 31;
        return LocalDate.of(year, month + 1, day + 1);
    }

    @Override
    public UUID readUUID() {
        long msb = this.readLong();
        long lsb = this.readLong();
        return new UUID(msb, lsb);
    }

    @Override
    public void skip(int bytes) {
        this.index += bytes;
    }

    @Override
    public boolean hasMore() {
        return this.index < this.limit;
    }

    @Override
    public void close() {
    }

    public static int getVarUIntLength(int size) {
        if (size < 128) {
            return 1;
        }
        if (size < 16384) {
            return 2;
        }
        if (size < 0x200000) {
            return 3;
        }
        if (size < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int getVarIntLength(int value) {
        return BytesDataInput.getVarUIntLength(value < 0 ? (1 - value << 1) + 1 : value << 1);
    }

    public static int getVarULongLength(long size) {
        if (size < 128L) {
            return 1;
        }
        if (size < 16384L) {
            return 2;
        }
        if (size < 0x200000L) {
            return 3;
        }
        if (size < 0x10000000L) {
            return 4;
        }
        if (size < 0x800000000L) {
            return 5;
        }
        if (size < 0x40000000000L) {
            return 6;
        }
        if (size < 0x800000000000L) {
            return 7;
        }
        if (size < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static int getByteArrayLength(byte[] data) {
        return BytesDataInput.getVarUIntLength(data.length) + data.length;
    }
}

