/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.openzen.packetstreams.NetworkLogger;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.ServiceConnector;
import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.Session;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.NackRange;
import org.openzen.packetstreams.qpsp.PacketScheduler;
import org.openzen.packetstreams.qpsp.QPSPEndpoint;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;
import org.openzen.packetstreams.qpsp.StreamMultiplexer;
import org.openzen.packetstreams.qpsp.frames.CloseFrame;
import org.openzen.packetstreams.qpsp.frames.DataFrame;
import org.openzen.packetstreams.qpsp.frames.FinishPacketFrame;
import org.openzen.packetstreams.qpsp.frames.FragEndFrame;
import org.openzen.packetstreams.qpsp.frames.FragPartFrame;
import org.openzen.packetstreams.qpsp.frames.FragStartFrame;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.FrameQueue;
import org.openzen.packetstreams.qpsp.frames.OpenFrame;
import org.openzen.packetstreams.qpsp.frames.ServiceInfoFrame;
import org.openzen.packetstreams.qpsp.frames.StartFrame;
import org.openzen.packetstreams.qpsp.scheduler.StandardCongestionController;

public class QPSPConnection
implements Session {
    public static final int CONTROL_PRIORITY = Integer.MAX_VALUE;
    private static final int MAX_DECRYPTION_ERRORS = 16;
    private final QPSPEndpoint endpoint;
    public final Server server;
    public final NetworkLogger logger;
    public InetAddress remoteAddress;
    public int remotePort;
    public final long localID;
    public final long remoteID;
    public int maxPacketSize;
    public int maxBufferSize;
    public final int maxUDPPacketSize = 1200;
    public final boolean isServer;
    public final long remoteNonce;
    public final long localNonce;
    private final CryptoPublicKey remotePublicKey;
    private final CryptoKeyPair keyPair;
    private final CryptoSharedKey key;
    private final FrameQueue incomingQueue = new FrameQueue();
    private final Queue<FrameData> outgoingQueue = new LinkedList<FrameData>();
    private final ControlPacketStream outgoingStream = new ControlPacketStream();
    private final byte[] outgoingNonce;
    private final byte[] incomingNonce;
    private final Map<Integer, QPSPStream> streams = new HashMap<Integer, QPSPStream>();
    private final StreamMultiplexer multiplexer;
    private final PacketScheduler scheduler;
    private final Thread commandThread;
    public final BlockingQueue<Runnable> commandQueue = new LinkedBlockingQueue<Runnable>();
    private final Timer timer = new Timer();
    private KeepaliveTimerTask keepaliveTimer = null;
    private final Set<Long> receivedPackets = new HashSet<Long>();
    private long stopWaiting = 0L;
    private int streamCounter;
    private boolean closed = false;
    private long totalPacketsReceived = 0L;
    private long currentSeq = 0L;
    private long outgoingSeq = 0L;
    private long outgoingLossySeq = 0L;
    private int decryptionErrors = 0;
    private int keepaliveInterval = 20000;
    private int maxKeepaliveInterval = 120000;
    private long lastKeepalive = System.currentTimeMillis();
    private FrameData outgoingFragmenting = null;
    private int outgoingFragmentingOffset = 0;

    public QPSPConnection(QPSPEndpoint endpoint, InetAddress address, int port, long localID, long remoteID, int maxPacketSize, int maxBufferSize, long remoteNonce, long localNonce, Server server, boolean isServer, CryptoPublicKey remotePublicKey, CryptoKeyPair keyPair) {
        this.endpoint = endpoint;
        this.server = server;
        this.isServer = isServer;
        this.logger = endpoint.logger;
        this.remoteAddress = address;
        this.remotePort = port;
        this.localID = localID;
        this.remoteID = remoteID;
        this.remoteNonce = remoteNonce;
        this.localNonce = localNonce;
        this.remotePublicKey = remotePublicKey;
        this.keyPair = keyPair;
        this.key = endpoint.crypto.createSharedKey(remotePublicKey, keyPair.privateKey);
        this.multiplexer = new StreamMultiplexer(this);
        this.maxPacketSize = maxPacketSize;
        this.maxBufferSize = maxBufferSize;
        this.streamCounter = isServer ? 1 : 0;
        this.outgoingNonce = new byte[24];
        this.incomingNonce = new byte[24];
        QPSPConnection.setLong(this.outgoingNonce, 0, remoteNonce);
        QPSPConnection.setLong(this.incomingNonce, 0, localNonce);
        this.keepaliveTimer = new KeepaliveTimerTask();
        this.timer.scheduleAtFixedRate((TimerTask)this.keepaliveTimer, 1000L, 1000L);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                QPSPConnection.this.commandQueue.offer(() -> {
                    if (!QPSPConnection.this.outgoingQueue.isEmpty() || QPSPConnection.this.outgoingFragmenting != null) {
                        QPSPConnection.this.scheduler.resumeStreams();
                    }
                });
            }
        }, 50L, 50L);
        this.commandThread = new Thread(() -> {
            while (!this.closed) {
                try {
                    Runnable command = this.commandQueue.take();
                    if (command == null) continue;
                    command.run();
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.commandThread.start();
        this.scheduler = new StandardPacketScheduler(this, this.multiplexer, new StandardCongestionController());
    }

    @Override
    public CryptoPublicKey getRemoteKey() {
        return this.remotePublicKey;
    }

    @Override
    public void open(String path, ServiceConnector connector) {
        this.commandQueue.offer(() -> {
            QPSPStream stream = this.open(connector);
            stream.open(path, false);
            this.resume(stream);
        });
    }

    @Override
    public void open(String path, ServiceMeta cached, ServiceConnector connector) {
        this.commandQueue.offer(() -> {
            QPSPStream stream = this.open(connector);
            stream.open(path, true);
            stream.connect(cached);
            this.resume(stream);
        });
    }

    CryptoProvider getCrypto() {
        return this.endpoint.crypto;
    }

    int getEstimatedRTTInMillis() {
        return this.scheduler.getEstimatedRTTInMillis();
    }

    long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    long getLastPacketSentTimestamp() {
        return this.scheduler.getLastSentPacketTimestamp();
    }

    public QPSPStream getStream(int streamID) {
        if (!this.streams.containsKey(streamID)) {
            this.streams.put(streamID, new QPSPStream(this, streamID, null));
        }
        return this.streams.get(streamID);
    }

    void offer(Frame frame) {
        this.incomingQueue.offer(frame);
    }

    void send(FrameData frame, boolean immediately) {
        this.outgoingQueue.add(frame);
        this.multiplexer.resume(this.outgoingStream);
        if (immediately) {
            this.scheduler.resumeStreams();
        }
    }

    public long sendLosslessPacket(byte[] data) throws IOException {
        long seq = this.outgoingSeq++;
        BytesDataOutput output = new BytesDataOutput();
        output.writeVarULong(this.remoteID);
        this.encodeCompactedSEQ(output, seq);
        output.writeRawBytes(this.encrypt(data, this.remoteID, seq));
        this.endpoint.send(this, output.toByteArray());
        return seq;
    }

    public long sendLossyPacket(byte[] data) throws IOException {
        long seq = this.outgoingLossySeq++;
        BytesDataOutput output = new BytesDataOutput();
        output.writeVarULong(this.remoteID | 1L);
        this.encodeCompactedSEQ(output, seq);
        output.writeRawBytes(this.encrypt(data, this.remoteID | 1L, seq));
        this.endpoint.send(this, output.toByteArray());
        return seq;
    }

    public void stopWaiting(long seq) {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(11);
        this.encodeCompactedSEQ(output, seq);
        this.send(new FrameData(Integer.MAX_VALUE, seq, output.toByteArray(), true, false), false);
    }

    private List<NackRange> listNacks(long lastReceived) {
        ArrayList<NackRange> result = new ArrayList<NackRange>();
        long start = -1L;
        int length = 0;
        for (long l = this.stopWaiting; l < lastReceived; ++l) {
            if (this.receivedPackets.contains(l)) {
                if (length > 0) {
                    result.add(new NackRange(start, length));
                }
                length = 0;
                continue;
            }
            if (length == 0) {
                start = l;
            }
            ++length;
        }
        if (length > 0) {
            result.add(new NackRange(start, length));
        }
        return result;
    }

    void pause() {
        this.commandQueue.offer(() -> this.scheduler.pause());
    }

    void resume() {
        this.commandQueue.offer(() -> this.scheduler.resume());
    }

    void close() {
        this.commandQueue.offer(() -> {
            this.closed = true;
            this.scheduler.onSessionClosed();
        });
    }

    void assertOnNetworkThread() {
        if (Thread.currentThread() != this.commandThread) {
            throw new AssertionError();
        }
    }

    long getRemoteStreamCounter() {
        return this.streamCounter;
    }

    void initClient(int keepaliveInterval, int maxKeepaliveInterval) {
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
    }

    void initServer(int maxPacketSize, int maxBufferSize) {
        this.maxPacketSize = maxPacketSize;
        this.maxBufferSize = maxBufferSize;
    }

    void initFromStorage(int streamCounter) {
        this.streamCounter = streamCounter;
    }

    void setRemote(InetAddress address, int port) {
        this.commandQueue.offer(() -> {
            this.remoteAddress = address;
            this.remotePort = port;
        });
    }

    public boolean finishPacket(long seq) {
        if (seq < this.stopWaiting) {
            return true;
        }
        if (seq != this.currentSeq) {
            return false;
        }
        ++this.currentSeq;
        this.logger.log(4, this.localID, -1, "Finished " + seq);
        return true;
    }

    private QPSPStream open(ServiceConnector connector) {
        int streamID = this.streamCounter;
        this.streamCounter += 2;
        QPSPStream stream = new QPSPStream(this, streamID, connector);
        this.streams.put(streamID, stream);
        return stream;
    }

    void sendInit() {
        this.commandQueue.offer(() -> {
            try {
                BytesDataOutput output = new BytesDataOutput();
                output.writeVarULong(3L);
                output.writeVarULong(this.remoteID);
                output.writeULong(this.localNonce);
                output.writeVarUInt(0);
                output.writeRawBytes(this.keyPair.publicKey.encode());
                BytesDataOutput encrypted = new BytesDataOutput();
                encrypted.writeVarUInt(0);
                this.server.getCertificate().serialize(encrypted);
                encrypted.writeVarULong(this.localID);
                encrypted.writeVarUInt(this.server.getSessionStreamCount());
                encrypted.writeVarUInt(this.server.getMaxPacketSize());
                encrypted.writeVarUInt(this.server.getMaxBufferSize());
                output.writeByteArray(this.encrypt(encrypted.toByteArray(), 1L, 0L));
                this.endpoint.send(this, output.toByteArray());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    byte[] encrypt(byte[] data, long streamId, long seq) {
        return this.encrypt(data, 0, data.length, streamId, seq);
    }

    byte[] encrypt(byte[] data, int offset, int length, long streamId, long seq) {
        this.assertOnNetworkThread();
        QPSPConnection.setLong(this.outgoingNonce, 8, streamId);
        QPSPConnection.setLong(this.outgoingNonce, 16, seq);
        return this.key.encrypt(this.outgoingNonce, data, offset, length);
    }

    byte[] decrypt(byte[] data, int offset, int length, long streamId, long seq) throws CryptoDecryptionException {
        this.assertOnNetworkThread();
        QPSPConnection.setLong(this.incomingNonce, 8, streamId);
        QPSPConnection.setLong(this.incomingNonce, 16, seq);
        return this.key.decrypt(this.incomingNonce, data, offset, length);
    }

    void resume(QPSPStream stream) {
        this.assertOnNetworkThread();
        this.multiplexer.resume(stream);
        this.doResume();
    }

    void doResume() {
        if (this.closed) {
            return;
        }
        this.scheduler.resumeStreams();
    }

    CryptoPublicKey getPublicKey() {
        return this.keyPair.publicKey;
    }

    void onReceived(InetAddress address, int port, BytesDataInput input, boolean lossy) {
        this.commandQueue.offer(() -> this.doReceive(address, port, input, lossy));
    }

    private long decodeCompactedSEQ(BytesDataInput input) {
        return input.readVarULong();
    }

    private void encodeCompactedSEQ(BytesDataOutput output, long seq) {
        output.writeVarULong(seq);
    }

    private void doReceive(InetAddress address, int port, BytesDataInput input, boolean lossy) {
        ++this.totalPacketsReceived;
        this.remoteAddress = address;
        this.remotePort = port;
        long seq = this.decodeCompactedSEQ(input);
        try {
            byte[] decrypted = this.decrypt(input.getData(), input.getCurrentOffset(), input.getAvailable(), lossy ? this.localID | 1L : this.localID, seq);
            this.onReceived(seq, lossy, decrypted);
            this.scheduler.onPacketReceived();
            Map<QPSPStream, Long> result = this.incomingQueue.getBlockingSeq();
            for (Map.Entry<QPSPStream, Long> entry : result.entrySet()) {
                this.logger.log(8, this.localID, entry.getKey().id, "Waiting for frame " + entry.getValue());
            }
        }
        catch (CryptoDecryptionException ex) {
            this.logger.log(2, this.localID, -1, "Decryption error for #" + seq);
            ++this.decryptionErrors;
            if (this.decryptionErrors > 16) {
                // empty if block
            }
        }
    }

    private void enqueueAck(long seq) {
        this.receivedPackets.add(seq);
        List<NackRange> nacks = this.listNacks(seq);
        Collections.sort(nacks, (a, b) -> Long.compare(b.seq, a.seq));
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(6);
        this.encodeCompactedSEQ(output, seq);
        output.writeVarUInt(nacks.size());
        long last = seq;
        for (NackRange range : nacks) {
            long delta = last - range.seq;
            if (delta < 0L) {
                throw new AssertionError();
            }
            if (range.length == 1) {
                output.writeVarULong(delta * 2L);
            } else {
                output.writeVarULong(delta * 2L + 1L);
                output.writeVarUInt(range.length);
            }
            last = range.seq;
        }
        output.writeVarULong(last - this.currentSeq);
        this.send(new FrameData(Integer.MAX_VALUE, 0L, output.toByteArray(), true, false), false);
        StringBuilder nacksString = new StringBuilder();
        for (int i = 0; i < nacks.size(); ++i) {
            if (i > 0) {
                nacksString.append(", ");
            }
            NackRange nack = nacks.get(i);
            if (nack.length > 1) {
                nacksString.append(nack.seq).append("+").append(nack.length);
                continue;
            }
            nacksString.append(nack.seq);
        }
        if (nacks.size() > 0) {
            this.logger.log(16, this.localID, -1, "-> ACK " + this.currentSeq + "-" + seq + " NACK " + nacksString);
        } else {
            this.logger.log(16, this.localID, -1, "-> ACK " + this.currentSeq + "-" + seq);
        }
    }

    private void onReceived(long seq, boolean lossy, byte[] data) {
        if (!lossy && seq < this.currentSeq) {
            this.logger.log(4, this.localID, -1, "Dropping duplicate packet " + seq);
            return;
        }
        if (lossy) {
            this.logger.log(4, this.localID, -1, "Processing incoming lossy packet " + seq);
        } else {
            this.logger.log(4, this.localID, -1, "Processing incoming packet " + seq);
        }
        try {
            BytesDataInput input = new BytesDataInput(data);
            while (input.hasMore()) {
                int type = input.readUByte();
                switch (type) {
                    case 1: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        String path = input.readString();
                        this.logger.log(8, this.localID, stream.id, "<- OPEN " + path);
                        this.incomingQueue.offer(new OpenFrame(stream, path, true));
                        break;
                    }
                    case 2: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        String path = input.readString();
                        this.logger.log(8, this.localID, stream.id, "<- QUICKOPEN " + path);
                        this.incomingQueue.offer(new OpenFrame(stream, path, false));
                        break;
                    }
                    case 3: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        UUID uuid = input.readUUID();
                        int flags = input.readUByte();
                        int priority = input.readVarInt();
                        byte[] serviceInfo = input.readByteArray();
                        this.logger.log(8, this.localID, stream.id, "<- SERVICEINFO");
                        this.incomingQueue.offer(new ServiceInfoFrame(stream, new ServiceMeta(uuid, flags, priority, serviceInfo)));
                        break;
                    }
                    case 4: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        this.logger.log(8, this.localID, stream.id, "<- START");
                        int checksum = input.readUInt();
                        int priority = input.readVarInt();
                        byte[] initData = input.readByteArray();
                        this.incomingQueue.offer(new StartFrame(stream, checksum, priority, initData));
                        break;
                    }
                    case 5: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        long dataseq = stream.decodeCompactedSEQ(input);
                        this.logger.log(8, this.localID, stream.id, "<- DATA " + dataseq);
                        byte[] packetData = input.readByteArray();
                        this.incomingQueue.offer(new DataFrame(stream, dataseq, packetData));
                        break;
                    }
                    case 6: {
                        long ackseq = this.decodeCompactedSEQ(input);
                        NackRange[] nacks = new NackRange[input.readVarUInt()];
                        StringBuilder nacksString = new StringBuilder();
                        long last = ackseq;
                        for (int i = 0; i < nacks.length; ++i) {
                            long delta = input.readVarULong();
                            long nackseq = last - (delta >> 1);
                            int length = (delta & 1L) == 1L ? input.readVarUInt() : 1;
                            nacks[i] = new NackRange(nackseq, length);
                            last = nackseq;
                            if (i > 0) {
                                nacksString.append(", ");
                            }
                            if (length > 1) {
                                nacksString.append(nackseq).append("+").append(length);
                                continue;
                            }
                            nacksString.append(nackseq);
                        }
                        long startOfRange = last - input.readVarULong();
                        if (nacksString.length() > 0) {
                            this.logger.log(8, this.localID, -1, "<- ACK " + startOfRange + "-" + ackseq + " NACK " + nacksString);
                        } else {
                            this.logger.log(8, this.localID, -1, "<- ACK " + startOfRange + "-" + ackseq);
                        }
                        this.scheduler.onAcknowledged(startOfRange, ackseq, nacks);
                        break;
                    }
                    case 7: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        long dataseq = stream.decodeCompactedSEQ(input);
                        int reason = input.readVarUInt();
                        this.logger.log(8, this.localID, stream.id, "<- CLOSE " + dataseq + ": " + reason);
                        byte[] closeData = input.readByteArray();
                        this.incomingQueue.offer(new CloseFrame(stream, dataseq, reason, closeData));
                        break;
                    }
                    case 8: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        long dataseq = stream.decodeCompactedSEQ(input);
                        this.logger.log(8, this.localID, stream.id, "<- FRAGSTART");
                        byte[] fragment = input.readByteArray();
                        this.incomingQueue.offer(new FragStartFrame(stream, dataseq, fragment));
                        break;
                    }
                    case 9: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        long dataseq = stream.decodeCompactedSEQ(input);
                        this.logger.log(8, this.localID, stream.id, "<- FRAGPART");
                        byte[] fragment = input.readByteArray();
                        this.incomingQueue.offer(new FragPartFrame(stream, dataseq, fragment));
                        break;
                    }
                    case 10: {
                        QPSPStream stream = this.getStream(input.readVarUInt());
                        long dataseq = stream.decodeCompactedSEQ(input);
                        this.logger.log(8, this.localID, stream.id, "<- FRAGEND");
                        byte[] fragment = input.readByteArray();
                        this.incomingQueue.offer(new FragEndFrame(stream, dataseq, fragment));
                        break;
                    }
                    case 11: {
                        long stopWaitingNew = this.decodeCompactedSEQ(input);
                        for (long l = this.stopWaiting; l < stopWaitingNew; ++l) {
                            this.receivedPackets.remove(l);
                        }
                        this.stopWaiting = stopWaitingNew;
                        if (this.stopWaiting > this.currentSeq) {
                            this.currentSeq = this.stopWaiting;
                        }
                        this.logger.log(8, this.localID, -1, "<- STOP_WAITING " + stopWaitingNew);
                        break;
                    }
                    case 16: {
                        int maxPacketSize = input.readVarUInt();
                        int maxBufferSize = input.readVarUInt();
                        this.logger.log(8, this.localID, -1, "<- INITIALIZED");
                        this.initServer(maxPacketSize, maxBufferSize);
                        break;
                    }
                    case 17: {
                        this.logger.log(8, this.localID, -1, "<- KEEPALIVE");
                        long packetsReceived = input.readVarULong();
                        break;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logger.log(8, this.localID, -1, "Reading past end of stream");
        }
        if (!lossy) {
            this.enqueueAck(seq);
        }
        if (!lossy) {
            this.incomingQueue.offer(new FinishPacketFrame(this, seq));
        }
    }

    public void onClosed(long streamId) {
        this.scheduler.onStreamClosed(streamId);
    }

    public static void setLong(byte[] data, int offset, long value) {
        data[offset + 0] = (byte)(value >> 56);
        data[offset + 1] = (byte)(value >> 48);
        data[offset + 2] = (byte)(value >> 40);
        data[offset + 3] = (byte)(value >> 32);
        data[offset + 4] = (byte)(value >> 24);
        data[offset + 5] = (byte)(value >> 16);
        data[offset + 6] = (byte)(value >> 8);
        data[offset + 7] = (byte)value;
    }

    private class ControlPacketStream
    implements StreamMultiplexer.Stream {
        private ControlPacketStream() {
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public FrameData next(int availableSpaceInPacket) {
            return (FrameData)QPSPConnection.this.outgoingQueue.poll();
        }
    }

    private class KeepaliveTimerTask
    extends TimerTask {
        private KeepaliveTimerTask() {
        }

        @Override
        public void run() {
            QPSPConnection.this.commandQueue.offer(() -> {
                long now = System.currentTimeMillis();
                if (now - QPSPConnection.this.getLastPacketSentTimestamp() < (long)QPSPConnection.this.keepaliveInterval && now - QPSPConnection.this.lastKeepalive < (long)QPSPConnection.this.maxKeepaliveInterval) {
                    return;
                }
                QPSPConnection.this.lastKeepalive = now;
                BytesDataOutput output = new BytesDataOutput();
                output.writeVarUInt(17);
                output.writeVarULong(QPSPConnection.this.getTotalPacketsReceived());
                QPSPConnection.this.send(new FrameData(Integer.MAX_VALUE, 0L, output.toByteArray(), true, true), true);
            });
        }
    }
}

