/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openzen.packetstreams.ClientSession;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Session;
import org.openzen.packetstreams.SigningRootValidator;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPEndpoint;

public class QPSPConnectionRequest
implements ClientSession {
    private final QPSPEndpoint endpoint;
    private final CryptoKeyPair keyPair;
    private final long clientNonce;
    public final String host;
    private final InetAddress address;
    private final int port;
    private final List<Consumer<Session>> whenEstablished = new ArrayList<Consumer<Session>>();
    private final Server server;
    private final SigningRootValidator rootValidator;
    private final int keepaliveInterval;
    private final int maxKeepaliveInterval;
    private final long connectionId;
    private boolean established = false;
    private long serverNonce;
    private CryptoPublicKey serverKey;
    private QPSPConnection session;

    public QPSPConnectionRequest(QPSPEndpoint endpoint, Server local, String host, int port, CryptoKeyPair keyPair, long clientNonce, long connectionId, SigningRootValidator rootValidator, int keepaliveInterval, int maxKeepaliveInterval) throws UnknownHostException {
        this.host = host;
        this.port = port;
        this.endpoint = endpoint;
        this.keyPair = keyPair;
        this.clientNonce = clientNonce;
        this.server = local;
        this.address = InetAddress.getByName(host);
        this.rootValidator = rootValidator;
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
        this.connectionId = connectionId;
    }

    public void preInit(long serverNonce, CryptoPublicKey publicKey) {
        this.serverNonce = serverNonce;
        this.serverKey = publicKey;
    }

    public boolean isValidSigningRoot(CryptoVerifyKey rootKey) {
        return this.rootValidator.isValid(rootKey);
    }

    public QPSPConnection init(long remoteConnectionID, int maxPacketSize, int maxBufferSize) {
        this.established = true;
        QPSPConnection result = new QPSPConnection(this.endpoint, this.address, this.port, this.connectionId, remoteConnectionID, maxPacketSize, maxBufferSize, this.serverNonce, this.clientNonce, this.server, false, this.serverKey, this.keyPair);
        result.initClient(this.keepaliveInterval, this.maxKeepaliveInterval);
        for (Consumer<Session> listener : this.whenEstablished) {
            listener.accept(result);
        }
        return result;
    }

    @Override
    public void whenEstablished(Consumer<Session> listener) {
        this.whenEstablished.add(listener);
    }

    public byte[] decryptInit(byte[] init) throws CryptoDecryptionException {
        byte[] nonce = new byte[24];
        QPSPConnection.setLong(nonce, 0, this.clientNonce);
        QPSPConnection.setLong(nonce, 8, 1L);
        CryptoSharedKey sharedKey = this.endpoint.crypto.createSharedKey(this.serverKey, this.keyPair.privateKey);
        return sharedKey.decrypt(nonce, init, 0, init.length);
    }

    @Override
    public byte[] serialize() {
        if (!this.established) {
            return new byte[0];
        }
        BytesDataOutput output = new BytesDataOutput();
        output.writeByteArray(this.keyPair.privateKey.encode());
        output.writeByteArray(this.keyPair.publicKey.encode());
        output.writeByteArray(this.serverKey.encode());
        output.writeULong(this.clientNonce);
        output.writeULong(this.serverNonce);
        output.writeString(this.host);
        output.writeVarUInt(this.port);
        output.writeVarULong(this.session.localID);
        output.writeVarULong(this.session.remoteID);
        output.writeVarULong(this.session.getRemoteStreamCounter());
        return output.toByteArray();
    }
}

