/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.TreeMap;
import org.openzen.packetstreams.qpsp.QPSPTransmittingPacket;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;

public class TransmissionBuffer {
    private final StandardPacketScheduler scheduler;
    private final TreeMap<Long, QPSPTransmittingPacket> packets = new TreeMap();

    public TransmissionBuffer(StandardPacketScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void add(QPSPTransmittingPacket packet) {
        this.packets.put(packet.seq, packet);
    }

    public QPSPTransmittingPacket find(long seq) {
        return this.packets.get(seq);
    }

    public Long getLowestSeq() {
        return this.packets.isEmpty() ? null : this.packets.firstKey();
    }

    public QPSPTransmittingPacket ack(long seq) {
        QPSPTransmittingPacket packet = this.packets.remove(seq);
        if (packet == null) {
            return null;
        }
        if (packet.packet.acknowledged) {
            return null;
        }
        packet.ack();
        return packet;
    }

    public void retransmitted(QPSPTransmittingPacket packet) {
        packet.retransmitted = true;
        this.packets.remove(packet.seq);
    }
}

