/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class DataFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final long seq;
    private final byte[] data;

    public DataFrame(QPSPStream stream, long seq, byte[] data) {
        this.stream = stream;
        this.seq = seq;
        this.data = data;
    }

    @Override
    public boolean tryExecute() {
        if (!this.stream.isStarted()) {
            return false;
        }
        if (!this.stream.hasReached(this.seq)) {
            return false;
        }
        this.stream.deliver(this.seq, this.data);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public long getBlockingSeq() {
        return this.seq;
    }

    @Override
    public int length() {
        return 1 + BytesDataInput.getVarUIntLength(this.stream.id) + this.stream.getCompactedSEQLength(this.seq) + BytesDataInput.getVarUIntLength(this.data.length) + this.data.length;
    }

    @Override
    public FrameData encode() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(5);
        output.writeVarUInt(this.stream.id);
        this.stream.encodeCompactedSEQ(output, this.seq);
        output.writeByteArray(this.data);
        this.stream.logger.log(8, this.stream.connection.localID, this.stream.id, "-> DATA " + this.seq);
        return new FrameData(this.stream.getPriority(), this.seq, output.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(5);
        output.writeByteArray(this.data);
        this.stream.logger.log(8, this.stream.connection.localID, this.stream.id, "-> DATA (fragmented) " + this.seq);
        return new FrameData(this.stream.getPriority(), this.seq, output.toByteArray(), false, false);
    }
}

