/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;

public class FrameQueue {
    private Frame[] frames = new Frame[16];
    private int length = 0;

    public void offer(Frame frame) {
        if (frame.tryExecute()) {
            this.resolve();
            return;
        }
        if (this.length == this.frames.length) {
            this.frames = Arrays.copyOf(this.frames, this.frames.length * 2);
        }
        this.frames[this.length++] = frame;
    }

    public Map<QPSPStream, Long> getBlockingSeq() {
        HashMap<QPSPStream, Long> result = new HashMap<QPSPStream, Long>();
        for (int i = 0; i < this.length; ++i) {
            long seq;
            Frame frame = this.frames[i];
            QPSPStream stream = frame.getStream();
            if (stream == null || (seq = frame.getBlockingSeq()) < 0L) continue;
            Long current = (Long)result.get(stream);
            result.put(stream, current == null ? seq : Math.min(current, seq));
        }
        return result;
    }

    private void resolve() {
        boolean changed;
        do {
            if (this.length == 0) {
                return;
            }
            int tail = 0;
            changed = false;
            for (int head = 0; head < this.length; ++head) {
                if (this.frames[head].tryExecute()) {
                    changed = true;
                    continue;
                }
                this.frames[tail] = this.frames[head];
                ++tail;
            }
            this.length = tail;
        } while (changed);
    }
}

