/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;

public class OpenFrame
implements Frame {
    private final QPSPStream stream;
    private final String path;
    private final boolean emitServiceInfo;

    public OpenFrame(QPSPStream stream, String path, boolean emitServiceInfo) {
        this.stream = stream;
        this.path = path;
        this.emitServiceInfo = emitServiceInfo;
    }

    @Override
    public boolean tryExecute() {
        Server server = this.stream.getServer();
        Service service = server.getService(this.path);
        if (service == null) {
            this.stream.close(5, new byte[0]);
        } else {
            this.stream.setService(service);
            if (this.emitServiceInfo) {
                this.stream.transmitServiceMeta();
            }
        }
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }
}

