/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class ServiceInfoFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final ServiceMeta meta;

    public ServiceInfoFrame(QPSPStream stream, ServiceMeta meta) {
        this.stream = stream;
        this.meta = meta;
    }

    @Override
    public boolean tryExecute() {
        this.stream.deliverServiceInfo(this.meta);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public int length() {
        return 18 + BytesDataInput.getVarUIntLength(this.stream.id) + BytesDataInput.getVarUIntLength(this.meta.defaultPriority) + BytesDataInput.getVarUIntLength(this.meta.serviceInfo.length) + this.meta.serviceInfo.length;
    }

    @Override
    public FrameData encode() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(3);
        output.writeVarUInt(this.stream.id);
        output.writeUUID(this.meta.uuid);
        output.writeUByte(this.meta.flags);
        output.writeVarInt(this.meta.defaultPriority);
        output.writeByteArray(this.meta.serviceInfo);
        return new FrameData(this.stream.getPriority(), -1L, output.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(3);
        output.writeUUID(this.meta.uuid);
        output.writeUByte(this.meta.flags);
        output.writeVarInt(this.meta.defaultPriority);
        output.writeByteArray(this.meta.serviceInfo);
        return new FrameData(this.stream.getPriority(), -1L, output.toByteArray(), false, false);
    }
}

