/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class StartFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final int checksum;
    private final int priority;
    private final byte[] initData;

    public StartFrame(QPSPStream stream, int checksum, int priority, byte[] initData) {
        this.stream = stream;
        this.checksum = checksum;
        this.priority = priority;
        this.initData = initData;
    }

    @Override
    public boolean tryExecute() {
        Service service = this.stream.getService();
        if (service == null) {
            return false;
        }
        int calculatedChecksum = service.getMeta().checksum();
        if (this.checksum != calculatedChecksum) {
            this.stream.transmitServiceMeta();
        } else {
            this.stream.start(this.priority, this.initData);
        }
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public int length() {
        return 5 + BytesDataInput.getVarUIntLength(this.stream.id) + BytesDataInput.getVarIntLength(this.priority) + BytesDataInput.getByteArrayLength(this.initData);
    }

    @Override
    public FrameData encode() {
        BytesDataOutput frame = new BytesDataOutput();
        frame.writeUByte(4);
        frame.writeVarUInt(this.stream.id);
        frame.writeUInt(this.checksum);
        frame.writeVarInt(this.priority);
        frame.writeByteArray(this.initData);
        return new FrameData(this.priority, -1L, frame.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        BytesDataOutput frame = new BytesDataOutput();
        frame.writeUByte(4);
        frame.writeUInt(this.checksum);
        frame.writeVarInt(this.priority);
        frame.writeByteArray(this.initData);
        return new FrameData(this.priority, -1L, frame.toByteArray(), false, false);
    }
}

