/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.scheduler;

import org.openzen.packetstreams.qpsp.QPSPTransmittingPacket;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;
import org.openzen.packetstreams.qpsp.scheduler.CongestionController;

public class StandardCongestionController
implements CongestionController {
    private static final int DEFAULT_MSS = 1460;
    private static final int INITIAL_WINDOW = 14600;
    private static final int MINIMUM_WINDOW = 5840;
    private static final float LOSS_REDUCTION_FACTOR = 0.6f;
    private int bytesInFlight = 0;
    private int congestionWindow = 14600;
    private long endOfRecovery = 0L;
    private int ssthresh = Integer.MAX_VALUE;
    private StandardPacketScheduler scheduler;

    @Override
    public void setPacketScheduler(StandardPacketScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public boolean isCongested() {
        return this.bytesInFlight > this.congestionWindow;
    }

    @Override
    public void onSent(QPSPTransmittingPacket packet) {
        if (!packet.packet.lossy) {
            this.bytesInFlight += packet.packet.data.length;
        }
    }

    @Override
    public void onAckLossless(QPSPTransmittingPacket packet) {
        if (!packet.lost) {
            this.bytesInFlight -= packet.packet.data.length;
        }
        if (!this.inRecovery(packet.seq)) {
            this.congestionWindow = this.congestionWindow < this.ssthresh ? (this.congestionWindow += packet.packet.data.length) : (this.congestionWindow += 1460 * packet.packet.data.length / this.congestionWindow);
        }
    }

    @Override
    public void onAckDuplicate(long seq) {
    }

    @Override
    public void onPacketLost(QPSPTransmittingPacket packet) {
        if (!packet.lost) {
            this.bytesInFlight -= packet.packet.data.length;
            packet.lost = true;
        }
        if (!this.inRecovery(packet.seq)) {
            this.endOfRecovery = packet.seq;
            this.congestionWindow = (int)((float)this.congestionWindow * 0.6f);
            this.ssthresh = this.congestionWindow = Math.max(this.congestionWindow, this.getMinimumWindow());
        }
    }

    @Override
    public String getStateInfo() {
        return "window=" + this.bytesInFlight + "/" + this.congestionWindow;
    }

    private boolean inRecovery(long seq) {
        return seq <= this.endOfRecovery;
    }

    private int getMinimumWindow() {
        return Math.max(4 * this.scheduler.getEstimatedRTTInMillis(), 5840);
    }
}

