/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CryptoVerifyKey;

/**
 * Implements validation of a signing root.
 * 
 * Best practice: don't create an implementation that just returns true on every
 * root key. <b>Keeping your signing keys safe, and implementing root validators
 * correctly, is essential to system security: you need it to guarantee that the
 * server you communicate is indeed the one you intended to connect with.</b>
 */
public interface SigningRootValidator {
	boolean isValid(CryptoVerifyKey rootKey);
}
