/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPStream;

public interface Frame {
	/**
	 * Attempts to execute the instructions in the given frame. If the
	 * instruction cannot be completed (because it is waiting for reordered
	 * or missing data) it returns false and does nothing.
	 * 
	 * @return 
	 */
	boolean tryExecute();
	
	QPSPStream getStream();
	
	default long getBlockingSeq() {
		return -1;
	}
}
