/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CertificateChain;
import org.openzen.packetstreams.crypto.CryptoKeyPair;

public abstract class BaseServer implements Server {
	private final CryptoKeyPair keyPair;
	private final CertificateChain certificate;
	
	public BaseServer(CryptoKeyPair keyPair, CertificateChain certificate) {
		this.keyPair = keyPair;
		this.certificate = certificate;
	}

	@Override
	public CryptoKeyPair getKeyPair() {
		return keyPair;
	}

	@Override
	public CertificateChain getCertificate() {
		return certificate;
	}
}
