/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CryptoPublicKey;

/**
 * Implements a (client) session. Used to open client connections.
 */
public interface Connection {
	CryptoPublicKey getRemoteKey();
	
	void open(String path, ServiceConnector connector);
	
	void open(String path, ServiceMeta cached, ServiceConnector connector);
}
