/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.crypto;

/**
 * Since libsodium has a different library on Android and on desktop, this
 * interface makes it easy to plug in either. Both are assumed to interface
 * to libsodium.
 */
public interface CryptoProvider {
	public static final int VERIFY_KEY_LENGTH = 32;
	public static final int SIGNATURE_LENGTH = 64;
	public static final int NONCE_BYTES = 24;
	public static final int PUBLIC_KEY_BYTES = 32;
	public static final int MACBYTES = 16;
	public static final int SIGNING_KEY_LENGTH = 32;
	
	public CryptoPrivateKey decodePrivateKey(byte[] data);
	
	public CryptoPublicKey decodePublicKey(byte[] data);
	
	public CryptoSigningKey decodeSigningKey(byte[] data);
	
	public CryptoSigningKey generateSigningKey();
	
	public CryptoVerifyKey decodeVerifyKey(byte[] data);
	
	public CryptoSharedKey createSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey);
	
	public CryptoKeyPair generateKeyPair();
	
	public byte[] generateNonce();
}
