/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.congestion;

import org.openzen.packetstreams.qpsp.QPSPTransmittingPacket;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;

/**
 * Implements a congestion controller for the StandardPacketScheduler. Different
 * implementations may be created to experiment with alternative algorithms.
 */
public interface CongestionController {
	void setPacketScheduler(StandardPacketScheduler scheduler);
	
	boolean isCongested();
	
	void onSent(QPSPTransmittingPacket packet);
	
	void onAckLossless(QPSPTransmittingPacket packet);
	
	void onAckDuplicate(long seq);
	
	void onPacketLost(QPSPTransmittingPacket packet);
	
	String getStateInfo();
}
