/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;

/**
 *
 * @author Hoofdgebruiker
 */
public class InternalSocket implements UDPSocket {
	private final BlockingQueue<DatagramPacket> outgoing;
	private final BlockingQueue<DatagramPacket> incoming;
	
	private int packetsTransmitted = 0;
	private int packetsReceived = 0;
	private long dataTransmitted = 0;
	private long dataReceived = 0;
	
	public InternalSocket(BlockingQueue<DatagramPacket> outgoing, BlockingQueue<DatagramPacket> incoming) {
		this.outgoing = outgoing;
		this.incoming = incoming;
	}

	@Override
	public void open() throws SocketException {
		
	}

	@Override
	public void close() {
		
	}

	@Override
	public DatagramPacket receive() throws IOException {
		try {
			DatagramPacket result = incoming.take();
			packetsReceived++;
			dataReceived += result.getLength();
			return result;
		} catch (InterruptedException ex) {
			return null;
		}
	}

	@Override
	public void send(DatagramPacket packet) throws IOException {
		outgoing.offer(packet);
		packetsTransmitted++;
		dataTransmitted += packet.getLength();
	}

	@Override
	public int getTotalPacketsTransmitted() {
		return packetsTransmitted;
	}

	@Override
	public long getTotalDataTransmitted() {
		return dataTransmitted;
	}

	@Override
	public int getTotalPacketsReceived() {
		return packetsReceived;
	}

	@Override
	public long getTotalDataReceived() {
		return dataReceived;
	}
}
