/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.net.InetAddress;
import org.openzen.packetstreams.ConnectionListener;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.SigningRootValidator;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPEndpoint;

public class QPSPConnectionRequest {
    private final QPSPEndpoint endpoint;
    public final CryptoKeyPair keyPair;
    public final long clientNonce;
    public final String host;
    public final int port;
    private final Server server;
    private final SigningRootValidator rootValidator;
    private final int keepaliveInterval;
    private final int maxKeepaliveInterval;
    public final long connectionId;
    private final ConnectionListener listener;
    private long serverNonce;
    private CryptoPublicKey serverKey;

    public QPSPConnectionRequest(QPSPEndpoint endpoint, Server local, String host, int port, CryptoKeyPair keyPair, long clientNonce, long connectionId, SigningRootValidator rootValidator, ConnectionListener listener, int keepaliveInterval, int maxKeepaliveInterval) {
        this.host = host;
        this.port = port;
        this.endpoint = endpoint;
        this.keyPair = keyPair;
        this.clientNonce = clientNonce;
        this.server = local;
        this.rootValidator = rootValidator;
        this.listener = listener;
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
        this.connectionId = connectionId;
    }

    public QPSPConnectionRequest forReconnection(long connectionId, long clientNonce) {
        return new QPSPConnectionRequest(this.endpoint, this.server, this.host, this.port, this.keyPair, clientNonce, connectionId, this.rootValidator, this.listener, this.keepaliveInterval, this.maxKeepaliveInterval);
    }

    public void preInit(long serverNonce, CryptoPublicKey publicKey) {
        this.serverNonce = serverNonce;
        this.serverKey = publicKey;
    }

    public boolean isValidSigningRoot(CryptoVerifyKey rootKey) {
        return this.rootValidator.isValid(rootKey);
    }

    public QPSPConnection init(InetAddress address, int port, long remoteConnectionID, int maxPacketSize, int maxBufferSize) {
        QPSPConnection result = new QPSPConnection(this.endpoint, address, port, this.connectionId, remoteConnectionID, maxPacketSize, maxBufferSize, this.serverNonce, this.clientNonce, this.server, false, this.serverKey, this.keyPair, this);
        result.initClient(this.keepaliveInterval, this.maxKeepaliveInterval);
        this.listener.onConnected(result);
        return result;
    }

    public byte[] decryptInit(byte[] init) throws CryptoDecryptionException {
        byte[] nonce = new byte[24];
        QPSPConnection.setLong(nonce, 0, this.clientNonce);
        QPSPConnection.setLong(nonce, 8, 1L);
        CryptoSharedKey sharedKey = this.endpoint.crypto.createSharedKey(this.serverKey, this.keyPair.privateKey);
        return sharedKey.decrypt(nonce, init);
    }
}

