/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class CloseFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final long seq;
    private final int reason;
    private final byte[] info;

    public static CloseFrame deserialize(BytesDataInput input, QPSPConnection connection) {
        QPSPStream stream = connection.getStream(input.readVarUInt());
        long dataseq = stream.decodeCompactedSEQ(input);
        int reason = input.readVarUInt();
        connection.logger.log(8, connection.localID, stream.id, "<- CLOSE " + dataseq + ": " + reason);
        byte[] closeData = input.readByteArray();
        return new CloseFrame(stream, dataseq, reason, closeData);
    }

    public CloseFrame(QPSPStream stream, long seq, int reason, byte[] info) {
        this.stream = stream;
        this.seq = seq;
        this.reason = reason;
        this.info = info;
    }

    @Override
    public boolean tryExecute() {
        if (!this.stream.hasReached(this.seq)) {
            return false;
        }
        this.stream.deliverClose(this.seq, this.reason, this.info);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public long getBlockingSeq() {
        return this.seq;
    }

    @Override
    public int length() {
        return 1 + BytesDataInput.getVarUIntLength(this.stream.id) + this.stream.getCompactedSEQLength(this.seq) + BytesDataInput.getVarUIntLength(this.reason) + BytesDataInput.getVarUIntLength(this.info.length) + this.info.length;
    }

    @Override
    public FrameData encode() {
        BytesDataOutput close = new BytesDataOutput();
        close.writeUByte(7);
        close.writeVarUInt(this.stream.id);
        this.stream.encodeCompactedSEQ(close, this.seq);
        close.writeVarUInt(this.reason);
        close.writeByteArray(this.info);
        this.stream.logger.log(8, this.stream.connection.localID, this.stream.id, "-> CLOSE " + this.seq + ": " + this.reason);
        return new FrameData(this.stream.getPriority(), this.seq, close.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        BytesDataOutput close = new BytesDataOutput();
        close.writeUByte(7);
        close.writeVarUInt(this.reason);
        close.writeByteArray(this.info);
        this.stream.logger.log(8, this.stream.connection.localID, this.stream.id, "-> CLOSE (fragmented) " + this.seq + ": " + this.reason);
        return new FrameData(this.stream.getPriority(), this.seq, close.toByteArray(), false, false);
    }
}

