/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams;

import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.crypto.CertificateChain;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoSigningKey;

public abstract class BaseServer
implements Server {
    private final CryptoKeyPair keyPair;
    private final CertificateChain certificate;
    private final String domainName;

    public BaseServer(CryptoProvider crypto, CryptoSigningKey rootKey, String domainName) {
        this.keyPair = crypto.generateKeyPair();
        this.certificate = new CertificateChain(rootKey, this.keyPair.publicKey, domainName);
        this.domainName = domainName;
    }

    public BaseServer(CryptoKeyPair keyPair, CertificateChain certificate, String domainName) {
        this.keyPair = keyPair;
        this.certificate = certificate;
        this.domainName = domainName;
    }

    @Override
    public CryptoKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public CertificateChain getCertificate() {
        return this.certificate;
    }
}

