/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.Arrays;
import java.util.UUID;
import org.openzen.packetstreams.NetworkLogger;
import org.openzen.packetstreams.PacketHints;
import org.openzen.packetstreams.PacketStream;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.ServiceConnector;
import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.ServiceStream;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.StreamMultiplexer;
import org.openzen.packetstreams.qpsp.frames.CloseFrame;
import org.openzen.packetstreams.qpsp.frames.DataFrame;
import org.openzen.packetstreams.qpsp.frames.FragEndFrame;
import org.openzen.packetstreams.qpsp.frames.FragPartFrame;
import org.openzen.packetstreams.qpsp.frames.FragStartFrame;
import org.openzen.packetstreams.qpsp.frames.OpenFrame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;
import org.openzen.packetstreams.qpsp.frames.ServiceInfoFrame;
import org.openzen.packetstreams.qpsp.frames.StartFrame;

public class QPSPStream
implements PacketStream,
StreamMultiplexer.Stream {
    public final QPSPConnection connection;
    public final NetworkLogger logger;
    public final int id;
    private long outgoingSeq = 0L;
    private long currentSeq = 0L;
    private int priority = 0;
    private FrameData outgoingFragmenting = null;
    private int outgoingFragmentingOffset = 0;
    private Service service;
    private final ServiceConnector connector;
    private ServiceStream serviceStream;
    private BytesDataOutput incomingFragment = null;
    private boolean closed = false;
    private boolean connectedWithUpdatedInfo = false;

    public QPSPStream(QPSPConnection connection, int id, ServiceConnector connector) {
        this.connection = connection;
        this.logger = connection.logger;
        this.id = id;
        this.connector = connector;
    }

    public void open(String path, boolean quick) {
        this.connection.send(new OpenFrame(this, path, !quick).encode(), true);
    }

    public void connect(ServiceMeta meta) {
        byte[] init;
        if (this.connector == null) {
            throw new IllegalStateException("This is not a client stream");
        }
        this.priority = meta.defaultPriority;
        if (this.serviceStream == null) {
            init = this.connector.connect(meta);
            this.serviceStream = this.connector.onConnected(this);
            this.serviceStream.onConnected();
        } else {
            init = this.connector.connectWithUpdatedMeta(meta);
            if (init == null) {
                this.close(1, new byte[0]);
                return;
            }
        }
        this.connection.send(new StartFrame(this, meta.checksum(), this.priority, init).encode(), true);
    }

    public Server getServer() {
        return this.connection.server;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public long decodeCompactedSEQ(BytesDataInput input) {
        return input.readVarULong();
    }

    public void encodeCompactedSEQ(BytesDataOutput output, long value) {
        output.writeVarULong(value);
    }

    public int getCompactedSEQLength(long value) {
        return BytesDataInput.getVarULongLength(value);
    }

    @Override
    public void resume() {
        this.connection.runOnNetworkThread(() -> this.connection.resume(this));
    }

    @Override
    public void close(int reason, byte[] info) {
        this.connection.runOnNetworkThread(() -> {
            long seq = this.newSeq();
            this.connection.send(new CloseFrame(this, seq, reason, info).encode(), true);
        });
    }

    @Override
    public CryptoProvider getCrypto() {
        return this.connection.getCrypto();
    }

    @Override
    public int getEstimatedRTTInMillis() {
        return this.connection.getEstimatedRTTInMillis();
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void transmitServiceMeta() {
        this.connection.send(new ServiceInfoFrame(this, this.service.getMeta()).encode(), true);
    }

    public void start(int priority, byte[] initData) {
        if (this.serviceStream != null) {
            this.connection.logger.log(2, this.connection.localID, this.id, "Skipping double start");
            return;
        }
        this.serviceStream = this.service.open(this, initData);
        this.serviceStream.onConnected();
        this.priority = priority;
    }

    public boolean isStarted() {
        return this.serviceStream != null;
    }

    public void deliverServiceInfo(ServiceMeta meta) {
        if (this.connectedWithUpdatedInfo) {
            return;
        }
        this.connect(meta);
        this.connectedWithUpdatedInfo = true;
    }

    public void deliver(long seq, byte[] packet) {
        this.connection.assertOnNetworkThread();
        if (seq != this.currentSeq) {
            this.connection.logger.log(8, this.connection.localID, this.id, "Preventing duplicate delivery of " + seq);
            return;
        }
        this.logger.log(8, this.connection.localID, this.id, "<- DELIVERED " + seq);
        this.serviceStream.onReceived(packet);
        ++this.currentSeq;
    }

    public void deliverClose(long seq, int reason, byte[] info) {
        this.connection.assertOnNetworkThread();
        if (seq != this.currentSeq) {
            this.connection.logger.log(8, this.connection.localID, this.id, "Preventing duplicate delivery of " + seq);
            return;
        }
        if (reason != 0) {
            this.close(0, new byte[0]);
        }
        this.service = null;
        ++this.currentSeq;
        this.closed = true;
        this.connection.resume(this);
        this.connection.onClosed(this.id);
        if (this.serviceStream != null) {
            this.serviceStream.onConnectionClosed(reason, info);
        }
    }

    public void beginFragmented(long seq, byte[] data) {
        this.connection.assertOnNetworkThread();
        if (seq != this.currentSeq) {
            this.connection.logger.log(8, this.connection.localID, this.id, "Preventing duplicate delivery of " + seq);
            return;
        }
        if (this.incomingFragment != null) {
            this.close(3, new byte[0]);
            return;
        }
        this.incomingFragment = new BytesDataOutput();
        this.incomingFragment.writeRawBytes(data);
        ++this.currentSeq;
    }

    public void appendFragmented(long seq, byte[] data) {
        this.connection.assertOnNetworkThread();
        if (seq != this.currentSeq) {
            this.connection.logger.log(8, this.connection.localID, this.id, "Preventing duplicate delivery of " + seq);
            return;
        }
        if (this.incomingFragment == null) {
            this.close(3, new byte[0]);
            return;
        }
        this.incomingFragment.writeRawBytes(data);
        ++this.currentSeq;
    }

    public void finishFragmented(long seq, byte[] data) {
        this.connection.assertOnNetworkThread();
        if (seq != this.currentSeq) {
            this.connection.logger.log(8, this.connection.localID, this.id, "Preventing duplicate delivery of " + seq);
            return;
        }
        if (this.incomingFragment == null) {
            this.close(3, new byte[0]);
            return;
        }
        this.incomingFragment.writeRawBytes(data);
        ++this.currentSeq;
        BytesDataInput input = new BytesDataInput(this.incomingFragment.toByteArray());
        int fragmentType = input.readUByte();
        switch (fragmentType) {
            case 3: {
                UUID uuid = input.readUUID();
                int flags = input.readUByte();
                int defaultPriority = input.readVarInt();
                byte[] serviceInfo = input.readByteArray();
                this.deliverServiceInfo(new ServiceMeta(uuid, flags, defaultPriority, serviceInfo));
                break;
            }
            case 4: {
                int checksum = input.readVarUInt();
                int priority = input.readVarUInt();
                byte[] initData = input.readByteArray();
                this.connection.offer(new StartFrame(this, checksum, priority, initData));
                break;
            }
            case 5: {
                byte[] packetData = input.readByteArray();
                this.serviceStream.onReceived(packetData);
                this.deliver(seq, packetData);
                break;
            }
            case 7: {
                int reason = input.readVarUInt();
                byte[] closeData = input.readByteArray();
                this.deliverClose(seq, reason, closeData);
                break;
            }
            default: {
                this.close(3, new byte[0]);
            }
        }
        this.incomingFragment = null;
    }

    public boolean hasReached(long seq) {
        return seq <= this.currentSeq;
    }

    @Override
    public FrameData next(int availableSpaceInPacket) {
        if (this.closed) {
            return null;
        }
        if (this.outgoingFragmenting != null) {
            return this.nextFragment(availableSpaceInPacket).encode();
        }
        OutgoingFrame next = this.loadNext(availableSpaceInPacket);
        if (next == null) {
            return null;
        }
        if (next.length() > availableSpaceInPacket) {
            this.outgoingFragmenting = next.encodeAsFragmented();
            this.outgoingFragmentingOffset = 0;
            next = this.nextFragment(availableSpaceInPacket);
        }
        return next.encode();
    }

    private OutgoingFrame loadNext(int availableSpaceInPacket) {
        this.connection.assertOnNetworkThread();
        if (this.serviceStream == null) {
            return null;
        }
        int recommendedLength = availableSpaceInPacket - BytesDataInput.getVarUIntLength(this.id) - BytesDataInput.getVarUIntLength(availableSpaceInPacket) - this.getCompactedSEQLength(this.outgoingSeq) - 1;
        byte[] data = this.serviceStream.next(new PacketHints(recommendedLength));
        if (data == null) {
            return null;
        }
        return new DataFrame(this, this.newSeq(), data);
    }

    private OutgoingFrame nextFragment(int size) {
        if ((size -= 1 - BytesDataInput.getVarUIntLength(this.id) - this.getCompactedSEQLength(this.currentSeq) - BytesDataInput.getVarUIntLength(size)) < 0) {
            throw new AssertionError();
        }
        int until = Math.min(this.outgoingFragmenting.data.length, this.outgoingFragmentingOffset + size);
        byte[] fragment = Arrays.copyOfRange(this.outgoingFragmenting.data, this.outgoingFragmentingOffset, until);
        if (this.outgoingFragmentingOffset == 0) {
            long seq = this.outgoingFragmenting.seq;
            this.outgoingFragmentingOffset += fragment.length;
            return new FragStartFrame(this, seq, fragment);
        }
        if (until < this.outgoingFragmenting.data.length) {
            long seq = this.newSeq();
            this.outgoingFragmentingOffset += fragment.length;
            return new FragPartFrame(this, seq, fragment);
        }
        long seq = this.newSeq();
        this.outgoingFragmenting = null;
        return new FragEndFrame(this, seq, fragment);
    }

    public long newSeq() {
        return this.outgoingSeq++;
    }

    public void closeNow(int reason) {
        if (this.serviceStream == null) {
            return;
        }
        this.serviceStream.onConnectionClosed(reason, new byte[0]);
        this.serviceStream = null;
    }
}

