/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.TimerTask;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.StandardPacketScheduler;

public class QPSPTransmittingPacket
implements Comparable<QPSPTransmittingPacket> {
    public final long seq;
    public final QPSPPacket packet;
    public final long timestamp = System.currentTimeMillis();
    public boolean retransmitted = false;
    public boolean lost = false;
    public final long originalSeq;
    public final QPSPTransmittingPacket retransmissionOf;
    private final StandardPacketScheduler scheduler;
    private TimerTask retransmissionTimer;
    private boolean inFastRetransmit;

    public QPSPTransmittingPacket(long seq, QPSPPacket packet, StandardPacketScheduler scheduler, QPSPTransmittingPacket retransmissionOf) {
        this.seq = seq;
        this.packet = packet;
        this.scheduler = scheduler;
        this.originalSeq = retransmissionOf == null ? seq : retransmissionOf.originalSeq;
        this.retransmissionOf = retransmissionOf;
    }

    public void retransmitAt(int retransmissionTimeout) {
        this.retransmissionTimer = this.scheduler.retransmit(this, retransmissionTimeout);
    }

    public void ack() {
        this.packet.acknowledged = true;
        if (this.retransmissionTimer != null) {
            this.retransmissionTimer.cancel();
            this.retransmissionTimer = null;
        }
    }

    public void fastRetransmit(int timeout) {
        if (this.packet.acknowledged) {
            return;
        }
        if (this.inFastRetransmit) {
            return;
        }
        if (this.retransmissionTimer != null) {
            this.retransmissionTimer.cancel();
        }
        this.inFastRetransmit = true;
        this.retransmissionTimer = this.scheduler.retransmit(this, timeout);
    }

    @Override
    public int compareTo(QPSPTransmittingPacket o) {
        return Long.compare(this.seq, o.seq);
    }
}

