/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.io.IOException;
import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.NackRange;
import org.openzen.packetstreams.qpsp.PacketScheduler;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.QPSPTransmittingPacket;
import org.openzen.packetstreams.qpsp.StreamMultiplexer;
import org.openzen.packetstreams.qpsp.TransmissionBuffer;
import org.openzen.packetstreams.qpsp.congestion.CongestionController;

public class StandardPacketScheduler
implements PacketScheduler {
    private static final int FAST_RETRANSMIT_PACKETS = 5;
    private final QPSPConnection connection;
    private final StreamMultiplexer multiplexer;
    private final Timer timer = new Timer();
    private final TransmissionBuffer inFlight = new TransmissionBuffer();
    private final Queue<QPSPTransmittingPacket> retransmit = new PriorityQueue<QPSPTransmittingPacket>();
    private final CongestionController congestionController;
    private int latestRTT = 1000;
    private int srtt = 0;
    private boolean paused = false;
    private long lastSentPacketTimestamp = System.currentTimeMillis();
    private int packetsLostSinceLastReceived = 0;

    public StandardPacketScheduler(QPSPConnection connection, StreamMultiplexer multiplexer, CongestionController congestionController) {
        this.connection = connection;
        this.multiplexer = multiplexer;
        this.congestionController = congestionController;
        congestionController.setPacketScheduler(this);
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.packetsLostSinceLastReceived = 0;
        this.doResume();
    }

    @Override
    public void resumeStreams() {
        this.doResume();
    }

    @Override
    public void onPacketReceived() {
        this.packetsLostSinceLastReceived = 0;
        this.doResume();
    }

    @Override
    public void onAcknowledged(long fromSeq, long toSeq, NackRange[] nacks) {
        Arrays.sort(nacks, (a, b) -> Long.compare(a.seq, b.seq));
        int nacki = 0;
        for (long ackseq = fromSeq; ackseq <= toSeq; ++ackseq) {
            if (nacki < nacks.length && ackseq >= nacks[nacki].seq + (long)nacks[nacki].length) {
                ++nacki;
            }
            if (nacki < nacks.length && ackseq >= nacks[nacki].seq) continue;
            this.ack(this.inFlight.ack(ackseq));
        }
        Long lowest = this.inFlight.getLowestSeq();
        if (lowest != null) {
            this.connection.stopWaiting(lowest);
        }
        this.doResume();
    }

    private void ack(QPSPTransmittingPacket packet) {
        int rtt;
        if (packet == null) {
            return;
        }
        this.latestRTT = rtt = (int)(System.currentTimeMillis() - packet.timestamp);
        this.srtt = this.srtt == 0 ? rtt : (int)((float)this.srtt * 0.9f + (float)rtt * 0.1f);
        this.onAckLossless(packet);
        this.connection.logger.log(16, this.connection.localID, -1, "Ack " + packet.seq + ", rtt = " + this.latestRTT + ", " + this.congestionController.getStateInfo());
    }

    @Override
    public void onStreamClosed(int streamID) {
    }

    @Override
    public void onConnectionClosed() {
        this.timer.cancel();
    }

    @Override
    public int getEstimatedRTTInMillis() {
        return (this.srtt + this.latestRTT) / 2;
    }

    @Override
    public long getLastSentPacketTimestamp() {
        return this.lastSentPacketTimestamp;
    }

    public TimerTask retransmit(final QPSPTransmittingPacket packet, int timeout) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                StandardPacketScheduler.this.connection.runOnNetworkThread(() -> {
                    if (packet2.packet.acknowledged) {
                        return;
                    }
                    StandardPacketScheduler.this.retransmit.add(packet);
                    ((StandardPacketScheduler)StandardPacketScheduler.this).connection.logger.log(16, ((StandardPacketScheduler)StandardPacketScheduler.this).connection.localID, -1, "Scheduling for retransmission: #" + packet2.seq + "; " + StandardPacketScheduler.this.retransmit.size() + " packets in retransmission");
                    StandardPacketScheduler.this.onPacketLost(packet);
                });
            }
        };
        this.timer.schedule(task, timeout);
        return task;
    }

    private void doResume() {
        if (this.paused) {
            return;
        }
        while (this.sendPacket()) {
        }
    }

    private boolean sendPacket() {
        if (this.congestionController.isCongested()) {
            return false;
        }
        QPSPPacket next = null;
        if (this.packetsLostSinceLastReceived > 20) {
            if (this.multiplexer.peekPriority() == Integer.MAX_VALUE) {
                next = this.bundle();
            } else {
                return false;
            }
        }
        QPSPTransmittingPacket retransmitted = null;
        while (next == null && !this.retransmit.isEmpty()) {
            QPSPTransmittingPacket candidate = this.retransmit.peek();
            if (this.multiplexer.peekPriority() > candidate.packet.priority) break;
            if (candidate.packet.acknowledged) {
                this.connection.logger.log(16, this.connection.localID, -1, "Not retransmitting #" + candidate.seq + " since already acknowledged");
                this.retransmit.poll();
                continue;
            }
            retransmitted = this.retransmit.poll();
            this.inFlight.retransmitted(retransmitted);
            next = retransmitted.packet;
            this.connection.logger.log(16, this.connection.localID, -1, "Picked #" + retransmitted.seq + " for retransmission; " + this.retransmit.size() + " packets left");
            break;
        }
        if (next == null) {
            next = this.bundle();
        }
        if (next == null) {
            if (!this.retransmit.isEmpty()) {
                return true;
            }
            this.connection.logger.log(16, this.connection.localID, -1, "Stopping transmission; no data");
            return false;
        }
        if (next.data.length == 0) {
            throw new AssertionError();
        }
        try {
            this.lastSentPacketTimestamp = System.currentTimeMillis();
            long seq = next.lossy ? this.connection.sendLossyPacket(next.data) : this.connection.sendLosslessPacket(next.data);
            QPSPTransmittingPacket packet = new QPSPTransmittingPacket(seq, next, this, retransmitted);
            if (!next.lossy) {
                this.inFlight.add(packet);
                packet.retransmitAt(this.getTransmissionTimeout());
            }
            this.congestionController.onSent(packet);
            String active = this.multiplexer.getActive();
            if (retransmitted == null) {
                this.connection.logger.log(16, this.connection.localID, -1, "Transmitted #" + seq + ", " + this.congestionController.getStateInfo() + ", active=" + active);
            } else {
                this.connection.logger.log(16, this.connection.localID, -1, "Retransmitted #" + retransmitted.seq + " as #" + seq + " (originally " + retransmitted.originalSeq + "), " + this.congestionController.getStateInfo());
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private QPSPPacket bundle() {
        FrameData frame;
        boolean lossy = true;
        boolean keepalive = false;
        int priority = Integer.MIN_VALUE;
        BytesDataOutput output = new BytesDataOutput();
        for (int available = this.connection.maxUDPPacketSize; available > 32 && (frame = this.multiplexer.next(available - 5)) != null; available -= frame.data.length) {
            lossy &= frame.lossy;
            keepalive |= frame.keepalive;
            priority = Math.max(priority, frame.priority);
            output.writeRawBytes(frame.data);
        }
        if (output.length() == 0) {
            return null;
        }
        return new QPSPPacket(priority, output.toByteArray(), lossy, keepalive);
    }

    private void onAckLossless(QPSPTransmittingPacket packet) {
        this.congestionController.onAckLossless(packet);
        this.doResume();
    }

    private void onPacketLost(QPSPTransmittingPacket packet) {
        ++this.packetsLostSinceLastReceived;
        this.congestionController.onPacketLost(packet);
        this.doResume();
    }

    private int getTransmissionTimeout() {
        return (int)((float)Math.max(this.srtt, this.latestRTT) * 1.75f);
    }
}

