/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import org.openzen.packetstreams.qpsp.socket.UDPSocket;

public class InternalSocket
implements UDPSocket {
    private final BlockingQueue<DatagramPacket> outgoing;
    private final BlockingQueue<DatagramPacket> incoming;
    private int packetsTransmitted = 0;
    private int packetsReceived = 0;
    private long dataTransmitted = 0L;
    private long dataReceived = 0L;

    public InternalSocket(BlockingQueue<DatagramPacket> outgoing, BlockingQueue<DatagramPacket> incoming) {
        this.outgoing = outgoing;
        this.incoming = incoming;
    }

    @Override
    public void open() throws SocketException {
    }

    @Override
    public void close() {
    }

    @Override
    public DatagramPacket receive() throws IOException {
        try {
            DatagramPacket result = this.incoming.take();
            ++this.packetsReceived;
            this.dataReceived += (long)result.getLength();
            return result;
        }
        catch (InterruptedException ex) {
            return null;
        }
    }

    @Override
    public void send(DatagramPacket packet) throws IOException {
        this.outgoing.offer(packet);
        ++this.packetsTransmitted;
        this.dataTransmitted += (long)packet.getLength();
    }

    @Override
    public int getTotalPacketsTransmitted() {
        return this.packetsTransmitted;
    }

    @Override
    public long getTotalDataTransmitted() {
        return this.dataTransmitted;
    }

    @Override
    public int getTotalPacketsReceived() {
        return this.packetsReceived;
    }

    @Override
    public long getTotalDataReceived() {
        return this.dataReceived;
    }
}

