/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CertificateChain;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoSigningKey;

public abstract class BaseServer implements Server {
	private final CryptoKeyPair keyPair;
	private final CertificateChain certificate;
	private final String domainName;
	
	public BaseServer(CryptoProvider crypto, CryptoSigningKey rootKey, String domainName) {
		keyPair = crypto.generateKeyPair();
		certificate = new CertificateChain(rootKey, keyPair.publicKey, domainName);
		this.domainName = domainName;
	}
	
	public BaseServer(CryptoKeyPair keyPair, CertificateChain certificate, String domainName) {
		this.keyPair = keyPair;
		this.certificate = certificate;
		this.domainName = domainName;
	}
	
	@Override
	public String getDomainName() {
		return domainName;
	}

	@Override
	public CryptoKeyPair getKeyPair() {
		return keyPair;
	}

	@Override
	public CertificateChain getCertificate() {
		return certificate;
	}
}
