/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CertificateChain;
import org.openzen.packetstreams.crypto.CryptoKeyPair;

public class EmptyServer implements Server {
	private final CryptoKeyPair keyPair;
	
	public EmptyServer(CryptoKeyPair keyPair) {
		this.keyPair = keyPair;
	}
	
	@Override
	public String getDomainName() {
		return "";
	}

	@Override
	public Service getService(String path) {
		return null;
	}

	@Override
	public CryptoKeyPair getKeyPair() {
		return keyPair;
	}

	@Override
	public CertificateChain getCertificate() {
		throw new UnsupportedOperationException();
	}
}
