/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp;

import java.util.TreeMap;

public class TransmissionBuffer {
	private final TreeMap<Long, QPSPTransmittingPacket> packets = new TreeMap<>();
	
	public void add(QPSPTransmittingPacket packet) {
		packets.put(packet.seq, packet);
	}
	
	public QPSPTransmittingPacket find(long seq) {
		return packets.get(seq);
	}
	
	public Long getLowestSeq() {
		return packets.isEmpty() ? null : packets.firstKey();
	}
	
	public QPSPTransmittingPacket ack(long seq) {
		QPSPTransmittingPacket packet = packets.remove(seq);
		if (packet == null)
			return null;
		if (packet.packet.acknowledged)
			return null;
		
		packet.ack();
		return packet;
	}
	
	public void retransmitted(QPSPTransmittingPacket packet) {
		packet.retransmitted = true;
		packets.remove(packet.seq);
	}
}
