/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class FrameQueue {
	private Frame[] frames = new Frame[16];
	private int length = 0;
	
	public void offer(Frame frame) {
		if (frame.tryExecute()) {
			resolve();
			return;
		}
		
		if (length == frames.length)
			frames = Arrays.copyOf(frames, frames.length * 2);
		
		frames[length++] = frame;
	}
	
	public Map<QPSPStream, Long> getBlockingSeq() {
		Map<QPSPStream, Long> result = new HashMap<>();
		for (int i = 0; i < length; i++) {
			Frame frame = frames[i];
			QPSPStream stream = frame.getStream();
			if (stream == null)
				continue;
			long seq = frame.getBlockingSeq();
			if (seq < 0)
				continue;
			
			Long current = result.get(stream);
			result.put(stream, current == null ? seq : Math.min(current, seq));
		}
		
		return result;
	}
	
	// Attempt to run blocked operations
	private void resolve() {
		boolean changed;
		do {
			if (length == 0)
				return;
			
			int head = 0;
			int tail = 0;
			changed = false;
			
			while (head < length) {
				if (frames[head].tryExecute()) {
					changed = true;
				} else {
					frames[tail] = frames[head];
					tail++;
				}
				head++;
			}

			length = tail;
		} while (changed);
	}
}
