/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Service connectors are used by clients to help connecting to a requested
 * service. They implement behavior if service metadata has been updated as well
 * as providing the client service stream implementation.
 */
public interface ServiceConnector {
	/**
	 * Invoked when an session is ready to make a service connection. Returns
	 * the init data, given the supplied service metadata. May return null to
	 * reject the connection. (for instance, because the service is not of an
	 * expected or supported type)
	 * 
	 * @param meta service metadata
	 * @return service initialization data
	 */
	public byte[] connect(ServiceMeta meta);
	
	/**
	 * Invoked when service metadata doesn't match the cached version. Returns
	 * the init data, given the supplied service metadata. May return null to
	 * close the connection.
	 * 
	 * Note that if the connection is accepted, data already sent WILL be
	 * delivered to the service and the existing stream will be kept. If this
	 * behavior is not desired, close the connection by returning null and
	 * re-initiate a connection instead.
	 * 
	 * @param meta service metadata
	 * @return service initialization data
	 */
	public byte[] connectWithUpdatedMeta(ServiceMeta meta);
	
	/**
	 * Invoked when a connection has been established with the requested service.
	 * Returns the actual client implementation.
	 * 
	 * @param stream packet stream to the service
	 * @return client service stream implementation
	 */
	public ServiceStream onConnected(PacketStream stream);
}
