/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class FinishPacketFrame implements Frame {
	private final QPSPConnection connection;
	private final long seq;

	public FinishPacketFrame(QPSPConnection connection, long seq) {
		this.connection = connection;
		this.seq = seq;
	}
	
	@Override
	public boolean tryExecute() {
		return connection.finishPacket(seq);
	}
	
	@Override
	public QPSPStream getStream() {
		return null;
	}

	@Override
	public long getBlockingSeq() {
		return -1;
	}
}
