/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.io;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.UUID;
import org.openzen.packetstreams.io.DataOutput;

public class BytesDataOutput
implements DataOutput {
    private static final int P7 = 128;
    private static final int P14 = 16384;
    private static final int P21 = 0x200000;
    private static final int P28 = 0x10000000;
    private static final long P35 = 0x800000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P56 = 0x100000000000000L;
    private byte[] data = new byte[16];
    private int length;

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.length);
    }

    public void clear() {
        this.length = 0;
    }

    @Override
    public void writeBoolean(boolean value) {
        this.writeUByte(value ? 1 : 0);
    }

    @Override
    public void writeSByte(byte value) {
        if (this.length + 1 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = value;
    }

    @Override
    public void writeUByte(int value) {
        this.writeSByte((byte)value);
    }

    @Override
    public void writeShort(short value) {
        if (this.length + 2 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    @Override
    public void writeUShort(int value) {
        this.writeShort((short)value);
    }

    @Override
    public void writeInt(int value) {
        if (this.length + 4 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    @Override
    public void writeUInt(int value) {
        this.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        if (this.length + 8 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >>> 56);
        this.data[this.length++] = (byte)(value >>> 48);
        this.data[this.length++] = (byte)(value >>> 40);
        this.data[this.length++] = (byte)(value >>> 32);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    @Override
    public void writeULong(long value) {
        this.writeLong(value);
    }

    @Override
    public void writeVarInt(int value) {
        this.writeVarUInt(value < 0 ? (1 - value << 1) + 1 : value << 1);
    }

    @Override
    public void writeVarUInt(int value) {
        if (this.length + 5 > this.data.length) {
            this.expand();
        }
        if (value >= 0 && value < 0x10000000) {
            if (value < 128) {
                this.data[this.length++] = (byte)(value & 0x7F);
            } else if (value < 16384) {
                this.data[this.length++] = (byte)(value & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 7 & 0x7F);
            } else if (value < 0x200000) {
                this.data[this.length++] = (byte)(value & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 7 & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 14 & 0x7F);
            } else {
                this.data[this.length++] = (byte)(value & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 7 & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 14 & 0x7F | 0x80);
                this.data[this.length++] = (byte)(value >> 21 & 0x7F);
            }
        } else {
            this.data[this.length++] = (byte)(value & 0x7F | 0x80);
            this.data[this.length++] = (byte)(value >>> 7 & 0x7F | 0x80);
            this.data[this.length++] = (byte)(value >>> 14 & 0x7F | 0x80);
            this.data[this.length++] = (byte)(value >>> 21 & 0x7F | 0x80);
            this.data[this.length++] = (byte)(value >>> 28 & 0x7F);
        }
    }

    @Override
    public void writeVarLong(long value) {
        this.writeVarULong(value < 0L ? (1L - value << 1) + 1L : value << 1);
    }

    @Override
    public void writeVarULong(long value) {
        if (this.length + 9 > this.data.length) {
            this.expand();
        }
        if (value >= 0L && value < 0x100000000000000L) {
            if (value < 128L) {
                this.data[this.length++] = (byte)(value & 0x7FL);
            } else if (value < 16384L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL);
            } else if (value < 0x200000L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL);
            } else if (value < 0x10000000L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 21 & 0x7FL);
            } else if (value < 0x800000000L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 21 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 28 & 0x7FL);
            } else if (value < 0x40000000000L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 21 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 28 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 35 & 0x7FL);
            } else if (value < 0x2000000000000L) {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 21 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 28 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 35 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 42 & 0x7FL);
            } else {
                this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 21 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 28 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 35 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 42 & 0x7FL | 0x80L);
                this.data[this.length++] = (byte)(value >> 49 & 0x7FL);
            }
        } else {
            this.data[this.length++] = (byte)(value & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 35 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 42 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 49 & 0x7FL | 0x80L);
            this.data[this.length++] = (byte)(value >>> 56);
        }
    }

    @Override
    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeChar(int value) {
        this.writeVarUInt(value);
    }

    @Override
    public void writeBytes(byte[] data) {
        this.writeVarUInt(data.length);
        this.writeRawBytes(data);
    }

    @Override
    public void writeBytes(byte[] data, int offset, int length) {
        this.writeVarUInt(length);
        this.writeRawBytes(data, offset, length);
    }

    @Override
    public void writeString(String str) {
        this.writeBytes(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeRawBytes(byte[] value) {
        while (this.length + value.length >= this.data.length) {
            this.expand();
        }
        for (byte b : value) {
            this.data[this.length++] = b;
        }
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) {
        if (offset + length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        while (this.length + length >= this.data.length) {
            this.expand();
        }
        for (int i = 0; i < length; ++i) {
            this.data[this.length++] = value[offset + i];
        }
    }

    @Override
    public void writeRawBytes(ByteBuffer data, int length) {
        while (this.length + length >= this.data.length) {
            this.expand();
        }
        data.get(this.data, this.length, length);
        this.length += length;
    }

    @Override
    public void writeAllBytes(ByteBuffer data) {
        int size = data.capacity();
        this.writeVarUInt(size);
        data.rewind();
        this.writeRawBytes(data, size);
    }

    @Override
    public void writeBytes(ByteBuffer data, int length) {
        this.writeVarUInt(length);
        this.writeRawBytes(data, length);
    }

    @Override
    public void writeByteArray(byte[] data) {
        this.writeBytes(data);
    }

    @Override
    public void writeUByteArray(byte[] data) {
        this.writeBytes(data);
    }

    @Override
    public void writeShortArray(short[] data) {
        this.writeVarUInt(data.length);
        for (short element : data) {
            this.writeShort(element);
        }
    }

    @Override
    public void writeShortArrayRaw(short[] data) {
        for (short element : data) {
            this.writeShort(element);
        }
    }

    @Override
    public void writeUShortArray(short[] data) {
        this.writeShortArray(data);
    }

    @Override
    public void writeUShortArrayRaw(short[] data) {
        this.writeShortArrayRaw(data);
    }

    @Override
    public void writeVarIntArray(int[] data) {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    @Override
    public void writeVarIntArrayRaw(int[] data) {
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    @Override
    public void writeVarUIntArray(int[] data) {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    @Override
    public void writeVarUIntArrayRaw(int[] data) {
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    @Override
    public void writeIntArray(int[] data) {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeInt(element);
        }
    }

    @Override
    public void writeIntArrayRaw(int[] data) {
        for (int element : data) {
            this.writeInt(element);
        }
    }

    @Override
    public void writeUIntArray(int[] data) {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    @Override
    public void writeUIntArrayRaw(int[] data) {
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    @Override
    public void writeVarLongArray(long[] data) {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    @Override
    public void writeVarLongArrayRaw(long[] data) {
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    @Override
    public void writeVarULongArray(long[] data) {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    @Override
    public void writeVarULongArrayRaw(long[] data) {
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    @Override
    public void writeLongArray(long[] data) {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeLong(element);
        }
    }

    @Override
    public void writeLongArrayRaw(long[] data) {
        for (long element : data) {
            this.writeLong(element);
        }
    }

    @Override
    public void writeULongArray(long[] data) {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeULong(element);
        }
    }

    @Override
    public void writeULongArrayRaw(long[] data) {
        for (long element : data) {
            this.writeULong(element);
        }
    }

    @Override
    public void writeFloatArray(float[] data) {
        this.writeVarUInt(data.length);
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    @Override
    public void writeFloatArrayRaw(float[] data) {
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    @Override
    public void writeDoubleArray(double[] data) {
        this.writeVarUInt(data.length);
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    @Override
    public void writeDoubleArrayRaw(double[] data) {
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    @Override
    public void writeStringArray(String[] data) {
        this.writeVarUInt(data.length);
        for (String element : data) {
            this.writeString(element);
        }
    }

    @Override
    public void writeStringArrayRaw(String[] data) {
        for (String element : data) {
            this.writeString(element);
        }
    }

    @Override
    public void writeDate(LocalDate value) {
        if (value == null) {
            this.writeVarInt(-32);
            return;
        }
        int ivalue = value.getYear() - 2000;
        ivalue = ivalue * 12 * 31 + (value.getMonthValue() - 1) * 31 + value.getDayOfMonth() - 1;
        this.writeVarInt(ivalue);
    }

    @Override
    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void expand() {
        this.data = Arrays.copyOf(this.data, this.data.length * 2);
    }
}

