/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.NackRange;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class AckFrame
implements Frame,
OutgoingFrame {
    private final QPSPConnection connection;
    private final long from;
    private final long to;
    private final NackRange[] nacks;

    public static AckFrame deserialize(BytesDataInput input, QPSPConnection connection) {
        long ackseq = connection.decodeCompactedSEQ(input);
        NackRange[] nacks = new NackRange[input.readVarUInt()];
        StringBuilder nacksString = new StringBuilder();
        long last = ackseq;
        for (int i = 0; i < nacks.length; ++i) {
            long delta = input.readVarULong();
            long nackseq = last - (delta >> 1);
            int length = (delta & 1L) == 1L ? input.readVarUInt() : 1;
            nacks[i] = new NackRange(nackseq, length);
            last = nackseq;
            if (i > 0) {
                nacksString.append(", ");
            }
            if (length > 1) {
                nacksString.append(nackseq).append("+").append(length);
                continue;
            }
            nacksString.append(nackseq);
        }
        long startOfRange = last - input.readVarULong();
        if (nacksString.length() > 0) {
            connection.logger.log(8, connection.localID, -1, "<- ACK " + startOfRange + "-" + ackseq + " NACK " + nacksString);
        } else {
            connection.logger.log(8, connection.localID, -1, "<- ACK " + startOfRange + "-" + ackseq);
        }
        return new AckFrame(connection, startOfRange, ackseq, nacks);
    }

    public AckFrame(QPSPConnection connection, long from, long to, NackRange[] nacks) {
        this.connection = connection;
        this.from = from;
        this.to = to;
        this.nacks = nacks;
    }

    @Override
    public boolean tryExecute() {
        this.connection.scheduler.onAcknowledged(this.from, this.to, this.nacks);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return null;
    }

    @Override
    public int length() {
        return this.encode().data.length;
    }

    @Override
    public FrameData encode() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(6);
        this.connection.encodeCompactedSEQ(output, this.to);
        output.writeVarUInt(this.nacks.length);
        long last = this.to;
        for (NackRange range : this.nacks) {
            long delta = last - range.seq;
            if (delta < 0L) {
                throw new AssertionError();
            }
            if (range.length == 1) {
                output.writeVarULong(delta * 2L);
            } else {
                output.writeVarULong(delta * 2L + 1L);
                output.writeVarUInt(range.length);
            }
            last = range.seq;
        }
        output.writeVarULong(last - this.from);
        return new FrameData(Integer.MAX_VALUE, -1L, output.toByteArray(), true, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        return this.encode();
    }

    @Override
    public long getBlockingSeq() {
        return -1L;
    }
}

