/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import java.nio.charset.StandardCharsets;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class OpenFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final String path;
    private final boolean emitServiceInfo;

    public static OpenFrame deserializeOpen(BytesDataInput input, QPSPConnection connection) {
        QPSPStream stream = connection.getStream(input.readVarUInt());
        String path = input.readString();
        connection.logger.log(8, connection.localID, stream.id, "<- OPEN " + path);
        return new OpenFrame(stream, path, true);
    }

    public static OpenFrame deserializeQuickOpen(BytesDataInput input, QPSPConnection connection) {
        QPSPStream stream = connection.getStream(input.readVarUInt());
        String path = input.readString();
        connection.logger.log(8, connection.localID, stream.id, "<- QUICKOPEN " + path);
        return new OpenFrame(stream, path, false);
    }

    public OpenFrame(QPSPStream stream, String path, boolean emitServiceInfo) {
        this.stream = stream;
        this.path = path;
        this.emitServiceInfo = emitServiceInfo;
    }

    @Override
    public boolean tryExecute() {
        Server server = this.stream.getServer();
        Service service = server.getService(this.path);
        if (service == null) {
            this.stream.close(5, new byte[0]);
        } else {
            this.stream.setService(service);
            if (this.emitServiceInfo) {
                this.stream.transmitServiceMeta();
            }
        }
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public int length() {
        return 1 + BytesDataInput.getVarUIntLength(this.stream.getId()) + BytesDataInput.getByteArrayLength(this.path.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public FrameData encode() {
        BytesDataOutput frame = new BytesDataOutput();
        frame.writeUByte(this.emitServiceInfo ? 1 : 2);
        frame.writeVarUInt(this.stream.getId());
        frame.writeString(this.path);
        return new FrameData(this.stream.getPriority(), -1L, frame.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getBlockingSeq() {
        return -1L;
    }
}

