/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import java.util.UUID;
import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class ServiceInfoFrame
implements Frame,
OutgoingFrame {
    private final QPSPStream stream;
    private final ServiceMeta meta;

    public static ServiceInfoFrame deserialize(BytesDataInput input, QPSPConnection connection) {
        QPSPStream stream = connection.getStream(input.readVarUInt());
        UUID uuid = input.readUUID();
        int flags = input.readVarUInt();
        int priority = input.readVarInt();
        byte[] serviceInfo = input.readByteArray();
        connection.logger.log(8, connection.localID, stream.id, "<- SERVICEINFO");
        return new ServiceInfoFrame(stream, new ServiceMeta(uuid, flags, priority, serviceInfo));
    }

    public ServiceInfoFrame(QPSPStream stream, ServiceMeta meta) {
        this.stream = stream;
        this.meta = meta;
    }

    @Override
    public boolean tryExecute() {
        this.stream.deliverServiceInfo(this.meta);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return this.stream;
    }

    @Override
    public int length() {
        return 18 + BytesDataInput.getVarUIntLength(this.stream.id) + BytesDataInput.getVarUIntLength(this.meta.defaultPriority) + BytesDataInput.getByteArrayLength(this.meta.serviceInfo);
    }

    @Override
    public FrameData encode() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(3);
        output.writeVarUInt(this.stream.id);
        output.writeUUID(this.meta.uuid);
        output.writeVarUInt(this.meta.flags);
        output.writeVarInt(this.meta.defaultPriority);
        output.writeByteArray(this.meta.serviceInfo);
        return new FrameData(this.stream.getPriority(), -1L, output.toByteArray(), false, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(3);
        output.writeUUID(this.meta.uuid);
        output.writeVarUInt(this.meta.flags);
        output.writeVarInt(this.meta.defaultPriority);
        output.writeByteArray(this.meta.serviceInfo);
        return new FrameData(this.stream.getPriority(), -1L, output.toByteArray(), false, false);
    }

    @Override
    public long getBlockingSeq() {
        return -1L;
    }
}

