/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import org.openzen.packetstreams.crypto.CryptoProvider;

/**
 * Represents a single packet stream. Service streams make use of these
 * functions to communicate with the PacketStream system.
 */
public interface PacketStream {
	void resume();
	
	void close();
	
	void close(int reason, byte[] info);
	
	CryptoProvider getCrypto();
	
	int getEstimatedRTTInMillis();
}
