/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Service streams implement a client or server service stream. They are invoked
 * whenever a packet may be sent, when packets are to be delivered, on when
 * the stream opens and closes.
 */
public interface ServiceStream {
	byte[] next(PacketHints hints);
	
	void onConnected();
	
	void onReceived(byte[] packet);
	
	void onConnectionClosed(int reason, byte[] info);
}
