/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Implements a host supporting a single server.
 */
public class SingleServerHost implements Host {
	private final Server server;
	
	public SingleServerHost(Server server) {
		this.server = server;
	}

	@Override
	public Server getServer(String name) {
		if (name.equals(server.getDomainName()))
			return server;
		
		return null;
	}
}
