/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.Constants;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;

/**
 *
 * @author Hoofdgebruiker
 */
public class StopWaitingFrame implements Frame, OutgoingFrame {
	public static StopWaitingFrame deserialize(BytesDataInput input, QPSPConnection connection) {
		return new StopWaitingFrame(connection, connection.decodeCompactedSEQ(input));
	}
	
	private final QPSPConnection connection;
	private final long seq;
	
	public StopWaitingFrame(QPSPConnection connection, long seq) {
		this.connection = connection;
		this.seq = seq;
	}

	@Override
	public boolean tryExecute() {
		connection.deliverStopWaiting(seq);
		return true;
	}

	@Override
	public QPSPStream getStream() {
		return null;
	}

	@Override
	public int length() {
		return 1; // TODO: exact length
	}

	@Override
	public FrameData encode() {
		BytesDataOutput output = new BytesDataOutput();
		output.writeUByte(Constants.PACKET_STOP_WAITING);
		connection.encodeCompactedSEQ(output, seq);
		return new FrameData(Integer.MAX_VALUE, seq, output.toByteArray(), true, false);
	}

	@Override
	public FrameData encodeAsFragmented() {
		throw new UnsupportedOperationException("Not encodable as fragmented");
	}

	@Override
	public long getBlockingSeq() {
		return -1;
	}
}
