/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams;

import java.util.UUID;
import java.util.zip.CRC32;
import org.openzen.packetstreams.io.BytesDataOutput;

public class ServiceMeta {
    public static final int FLAG_META_CACHEABLE = 1;
    public static final int FLAG_CLIENT_SERVER_UNORDERED = 2;
    public static final int FLAG_SERVER_CLIENT_UNORDERED = 4;
    public final UUID uuid;
    public final int flags;
    public final int defaultPriority;
    public final byte[] serviceInfo;

    public ServiceMeta(UUID uuid, int flags, int defaultPriority, byte[] serviceInfo) {
        this.uuid = uuid;
        this.flags = flags;
        this.defaultPriority = defaultPriority;
        this.serviceInfo = serviceInfo;
    }

    public int checksum() {
        BytesDataOutput data = new BytesDataOutput();
        data.writeUUID(this.uuid);
        data.writeVarUInt(this.flags);
        data.writeVarUInt(this.defaultPriority);
        data.writeByteArray(this.serviceInfo);
        CRC32 crc = new CRC32();
        crc.update(data.toByteArray());
        return (int)crc.getValue();
    }
}

