/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.crypto;

import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;

public interface CryptoProvider {
    public static final int VERIFY_KEY_LENGTH = 32;
    public static final int SIGNATURE_LENGTH = 64;
    public static final int NONCE_BYTES = 24;
    public static final int PUBLIC_KEY_BYTES = 32;
    public static final int MACBYTES = 16;
    public static final int SIGNING_KEY_LENGTH = 32;

    public CryptoPrivateKey decodePrivateKey(byte[] var1);

    public CryptoPublicKey decodePublicKey(byte[] var1);

    public CryptoSigningKey decodeSigningKey(byte[] var1);

    public CryptoSigningKey generateSigningKey();

    public CryptoVerifyKey decodeVerifyKey(byte[] var1);

    public CryptoSharedKey createSharedKey(CryptoPublicKey var1, CryptoPrivateKey var2);

    public CryptoKeyPair generateKeyPair();

    public byte[] generateNonce();
}

